/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import com.google.protobuf.ByteString;
import java.util.Objects;
import org.hyperledger.fabric.client.ChaincodeEvent;
import org.hyperledger.fabric.client.GatewayUtils;

final class ChaincodeEventImpl
implements ChaincodeEvent {
    private final long blockNumber;
    private final String transactionId;
    private final String chaincodeName;
    private final String eventName;
    private final ByteString payload;
    private final int hash;

    ChaincodeEventImpl(long blockNumber, org.hyperledger.fabric.protos.peer.ChaincodeEvent event) {
        this.blockNumber = blockNumber;
        this.transactionId = event.getTxId();
        this.chaincodeName = event.getChaincodeId();
        this.eventName = event.getEventName();
        this.payload = event.getPayload();
        this.hash = Objects.hash(blockNumber, this.transactionId, this.chaincodeName, this.eventName);
    }

    @Override
    public long getBlockNumber() {
        return this.blockNumber;
    }

    @Override
    public String getTransactionId() {
        return this.transactionId;
    }

    @Override
    public String getChaincodeName() {
        return this.chaincodeName;
    }

    @Override
    public String getEventName() {
        return this.eventName;
    }

    @Override
    public byte[] getPayload() {
        return this.payload.toByteArray();
    }

    public boolean equals(Object other) {
        if (!(other instanceof ChaincodeEventImpl)) {
            return false;
        }
        ChaincodeEventImpl that = (ChaincodeEventImpl)other;
        return this.blockNumber == that.blockNumber && Objects.equals(this.transactionId, that.transactionId) && Objects.equals(this.chaincodeName, that.chaincodeName) && Objects.equals(this.eventName, that.eventName) && Objects.equals(this.payload, that.payload);
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return GatewayUtils.toString(this, "blockNumber: " + this.blockNumber, "transactionId: " + this.transactionId, "chaincodeName: " + this.chaincodeName, "eventName: " + this.eventName, "payload: " + this.payload);
    }
}

