/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.client;

import com.google.protobuf.ByteString;
import java.util.Objects;
import org.hyperledger.fabric.client.BlockEventsEnvelopeBuilder;
import org.hyperledger.fabric.client.Checkpoint;
import org.hyperledger.fabric.client.FilteredBlockEventsRequest;
import org.hyperledger.fabric.client.FilteredBlockEventsRequestImpl;
import org.hyperledger.fabric.client.GatewayClient;
import org.hyperledger.fabric.client.SigningIdentity;
import org.hyperledger.fabric.protos.common.Envelope;

final class FilteredBlockEventsBuilder
implements FilteredBlockEventsRequest.Builder {
    private final GatewayClient client;
    private final SigningIdentity signingIdentity;
    private final BlockEventsEnvelopeBuilder envelopeBuilder;

    FilteredBlockEventsBuilder(GatewayClient client, SigningIdentity signingIdentity, String channelName, ByteString tlsCertificateHash) {
        Objects.requireNonNull(channelName, "channel name");
        this.client = client;
        this.signingIdentity = signingIdentity;
        this.envelopeBuilder = new BlockEventsEnvelopeBuilder(signingIdentity, channelName, tlsCertificateHash);
    }

    @Override
    public FilteredBlockEventsBuilder startBlock(long blockNumber) {
        this.envelopeBuilder.startBlock(blockNumber);
        return this;
    }

    @Override
    public FilteredBlockEventsBuilder checkpoint(Checkpoint checkpoint) {
        checkpoint.getBlockNumber().ifPresent(this.envelopeBuilder::startBlock);
        return this;
    }

    @Override
    public FilteredBlockEventsRequest build() {
        Envelope request = this.envelopeBuilder.build();
        return new FilteredBlockEventsRequestImpl(this.client, this.signingIdentity, request);
    }
}

