/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.protos.gossip;

import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hyperledger.fabric.protos.gossip.DataRequestOrBuilder;
import org.hyperledger.fabric.protos.gossip.MessageProto;
import org.hyperledger.fabric.protos.gossip.PullMsgType;

public final class DataRequest
extends GeneratedMessageV3
implements DataRequestOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int NONCE_FIELD_NUMBER = 1;
    private long nonce_ = 0L;
    public static final int DIGESTS_FIELD_NUMBER = 2;
    private List<ByteString> digests_;
    public static final int MSG_TYPE_FIELD_NUMBER = 3;
    private int msgType_ = 0;
    private byte memoizedIsInitialized = (byte)-1;
    private static final DataRequest DEFAULT_INSTANCE = new DataRequest();
    private static final Parser<DataRequest> PARSER = new AbstractParser<DataRequest>(){

        public DataRequest parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = DataRequest.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private DataRequest(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private DataRequest() {
        this.digests_ = Collections.emptyList();
        this.msgType_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new DataRequest();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return MessageProto.internal_static_gossip_DataRequest_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return MessageProto.internal_static_gossip_DataRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(DataRequest.class, Builder.class);
    }

    @Override
    public long getNonce() {
        return this.nonce_;
    }

    @Override
    public List<ByteString> getDigestsList() {
        return this.digests_;
    }

    @Override
    public int getDigestsCount() {
        return this.digests_.size();
    }

    @Override
    public ByteString getDigests(int index) {
        return this.digests_.get(index);
    }

    @Override
    public int getMsgTypeValue() {
        return this.msgType_;
    }

    @Override
    public PullMsgType getMsgType() {
        PullMsgType result = PullMsgType.forNumber(this.msgType_);
        return result == null ? PullMsgType.UNRECOGNIZED : result;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        if (this.nonce_ != 0L) {
            output.writeUInt64(1, this.nonce_);
        }
        for (int i = 0; i < this.digests_.size(); ++i) {
            output.writeBytes(2, this.digests_.get(i));
        }
        if (this.msgType_ != PullMsgType.UNDEFINED.getNumber()) {
            output.writeEnum(3, this.msgType_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (this.nonce_ != 0L) {
            size += CodedOutputStream.computeUInt64Size((int)1, (long)this.nonce_);
        }
        int dataSize = 0;
        for (int i = 0; i < this.digests_.size(); ++i) {
            dataSize += CodedOutputStream.computeBytesSizeNoTag((ByteString)this.digests_.get(i));
        }
        size += dataSize;
        size += 1 * this.getDigestsList().size();
        if (this.msgType_ != PullMsgType.UNDEFINED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)3, (int)this.msgType_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DataRequest)) {
            return super.equals(obj);
        }
        DataRequest other = (DataRequest)obj;
        if (this.getNonce() != other.getNonce()) {
            return false;
        }
        if (!this.getDigestsList().equals(other.getDigestsList())) {
            return false;
        }
        if (this.msgType_ != other.msgType_) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + DataRequest.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + Internal.hashLong((long)this.getNonce());
        if (this.getDigestsCount() > 0) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.getDigestsList().hashCode();
        }
        hash = 37 * hash + 3;
        hash = 53 * hash + this.msgType_;
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static DataRequest parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (DataRequest)PARSER.parseFrom(data);
    }

    public static DataRequest parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (DataRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static DataRequest parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (DataRequest)PARSER.parseFrom(data);
    }

    public static DataRequest parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (DataRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static DataRequest parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (DataRequest)PARSER.parseFrom(data);
    }

    public static DataRequest parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (DataRequest)PARSER.parseFrom(data, extensionRegistry);
    }

    public static DataRequest parseFrom(InputStream input) throws IOException {
        return (DataRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static DataRequest parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (DataRequest)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static DataRequest parseDelimitedFrom(InputStream input) throws IOException {
        return (DataRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static DataRequest parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (DataRequest)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static DataRequest parseFrom(CodedInputStream input) throws IOException {
        return (DataRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static DataRequest parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (DataRequest)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return DataRequest.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(DataRequest prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static DataRequest getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<DataRequest> parser() {
        return PARSER;
    }

    public Parser<DataRequest> getParserForType() {
        return PARSER;
    }

    public DataRequest getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements DataRequestOrBuilder {
        private int bitField0_;
        private long nonce_;
        private List<ByteString> digests_ = Collections.emptyList();
        private int msgType_ = 0;

        public static final Descriptors.Descriptor getDescriptor() {
            return MessageProto.internal_static_gossip_DataRequest_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return MessageProto.internal_static_gossip_DataRequest_fieldAccessorTable.ensureFieldAccessorsInitialized(DataRequest.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.nonce_ = 0L;
            this.digests_ = Collections.emptyList();
            this.msgType_ = 0;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return MessageProto.internal_static_gossip_DataRequest_descriptor;
        }

        public DataRequest getDefaultInstanceForType() {
            return DataRequest.getDefaultInstance();
        }

        public DataRequest build() {
            DataRequest result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public DataRequest buildPartial() {
            DataRequest result = new DataRequest(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(DataRequest result) {
            if ((this.bitField0_ & 2) != 0) {
                this.digests_ = Collections.unmodifiableList(this.digests_);
                this.bitField0_ &= 0xFFFFFFFD;
            }
            result.digests_ = this.digests_;
        }

        private void buildPartial0(DataRequest result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.nonce_ = this.nonce_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.msgType_ = this.msgType_;
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof DataRequest) {
                return this.mergeFrom((DataRequest)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(DataRequest other) {
            if (other == DataRequest.getDefaultInstance()) {
                return this;
            }
            if (other.getNonce() != 0L) {
                this.setNonce(other.getNonce());
            }
            if (!other.digests_.isEmpty()) {
                if (this.digests_.isEmpty()) {
                    this.digests_ = other.digests_;
                    this.bitField0_ &= 0xFFFFFFFD;
                } else {
                    this.ensureDigestsIsMutable();
                    this.digests_.addAll(other.digests_);
                }
                this.onChanged();
            }
            if (other.msgType_ != 0) {
                this.setMsgTypeValue(other.getMsgTypeValue());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block11: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block11;
                        }
                        case 8: {
                            this.nonce_ = input.readUInt64();
                            this.bitField0_ |= 1;
                            continue block11;
                        }
                        case 18: {
                            ByteString v = input.readBytes();
                            this.ensureDigestsIsMutable();
                            this.digests_.add(v);
                            continue block11;
                        }
                        case 24: {
                            this.msgType_ = input.readEnum();
                            this.bitField0_ |= 4;
                            continue block11;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public long getNonce() {
            return this.nonce_;
        }

        public Builder setNonce(long value) {
            this.nonce_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearNonce() {
            this.bitField0_ &= 0xFFFFFFFE;
            this.nonce_ = 0L;
            this.onChanged();
            return this;
        }

        private void ensureDigestsIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.digests_ = new ArrayList<ByteString>(this.digests_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<ByteString> getDigestsList() {
            return (this.bitField0_ & 2) != 0 ? Collections.unmodifiableList(this.digests_) : this.digests_;
        }

        @Override
        public int getDigestsCount() {
            return this.digests_.size();
        }

        @Override
        public ByteString getDigests(int index) {
            return this.digests_.get(index);
        }

        public Builder setDigests(int index, ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureDigestsIsMutable();
            this.digests_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addDigests(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureDigestsIsMutable();
            this.digests_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllDigests(Iterable<? extends ByteString> values) {
            this.ensureDigestsIsMutable();
            AbstractMessageLite.Builder.addAll(values, this.digests_);
            this.onChanged();
            return this;
        }

        public Builder clearDigests() {
            this.digests_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        @Override
        public int getMsgTypeValue() {
            return this.msgType_;
        }

        public Builder setMsgTypeValue(int value) {
            this.msgType_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        @Override
        public PullMsgType getMsgType() {
            PullMsgType result = PullMsgType.forNumber(this.msgType_);
            return result == null ? PullMsgType.UNRECOGNIZED : result;
        }

        public Builder setMsgType(PullMsgType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 4;
            this.msgType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearMsgType() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.msgType_ = 0;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

