/*
 * Decompiled with CFR 0.152.
 */
package org.i3xx.step.due.service.impl;

import java.io.IOException;
import org.i3xx.step.due.service.impl.InitializeMandatorTrackerImpl;
import org.i3xx.step.due.service.impl.InitializeSessionServiceTrackerImpl;
import org.i3xx.step.due.service.impl.PropertyScanner;
import org.i3xx.step.due.service.impl.SessionTrackerImpl;
import org.i3xx.step.due.service.model.InstPropertyService;
import org.i3xx.step.due.service.model.Session0Service;
import org.i3xx.step.due.service.model.SessionService;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivatorBean {
    static Logger logger = LoggerFactory.getLogger(ActivatorBean.class);
    private BundleContext bundleContext = null;
    private Session0Service session0Service = null;
    private SessionService sessionService = null;
    private InstPropertyService instPropertyService = null;
    private InitializeMandatorTrackerImpl mandatorTracker = null;
    private InitializeSessionServiceTrackerImpl sessionServiceTracker = null;
    private SessionTrackerImpl sessionTracker = null;

    public void startUp() throws IOException {
        logger.info("ActivatorBean started");
        this.mandatorTracker = new InitializeMandatorTrackerImpl(this.bundleContext, this.sessionService, this.session0Service, this.instPropertyService);
        this.mandatorTracker.open();
        this.sessionServiceTracker = new InitializeSessionServiceTrackerImpl(this.bundleContext, this.session0Service);
        this.sessionServiceTracker.open();
        this.sessionTracker = new SessionTrackerImpl(this.bundleContext);
        this.sessionTracker.open();
        PropertyScanner scan = new PropertyScanner();
        scan.setBundleContext(this.bundleContext);
        scan.setInstPropertyService(this.instPropertyService);
        scan.scanAll();
    }

    public void cleanUp() throws IOException {
        logger.info("ActivatorBean stopped");
        this.mandatorTracker.close();
        this.sessionTracker.close();
        this.sessionServiceTracker.close();
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public Session0Service getSession0Service() {
        return this.session0Service;
    }

    public void setSession0Service(Session0Service session0Service) {
        this.session0Service = session0Service;
    }

    public SessionService getSessionService() {
        return this.sessionService;
    }

    public void setSessionService(SessionService sessionService) {
        this.sessionService = sessionService;
    }

    public InstPropertyService getPropertyService() {
        return this.instPropertyService;
    }

    public void setInstPropertyService(InstPropertyService instPropertyService) {
        this.instPropertyService = instPropertyService;
    }
}

