/*
 * Decompiled with CFR 0.152.
 */
package org.i3xx.step.due.service.impl;

import java.io.File;
import java.io.IOException;
import org.i3xx.step.due.service.impl.DeployTool;
import org.i3xx.step.due.service.model.DeployService;
import org.i3xx.step.zero.service.impl.mandator.MandatorServiceImpl;
import org.i3xx.step.zero.service.model.mandator.Mandator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployServiceImpl
implements DeployService {
    static Logger logger = LoggerFactory.getLogger(DeployServiceImpl.class);
    private BundleContext bundleContext = null;

    public void startUp() throws IOException {
        logger.info("ResourceService started");
    }

    public File createEmptyZip(String processId, String mandatorId, String groupId, String artifactId) throws IOException {
        DeployServiceImpl.checkPermission("write", "resource");
        DeployServiceImpl.checkPermission("write", "property");
        DeployServiceImpl.checkPermission("write", "script");
        logger.debug("Archiv for {} requested process:{}, group:{}, artifact:{}.", new Object[]{processId, mandatorId, groupId, artifactId});
        DeployTool deploy = new DeployTool();
        deploy.checkArguments(processId, mandatorId, groupId, artifactId);
        Mandator mandator = MandatorServiceImpl.getMandator((BundleContext)this.bundleContext, (String)mandatorId);
        if (mandator == null) {
            throw new IOException("Not found: The requested mandator is not available at this system.");
        }
        return deploy.createEmptyZipA(mandator.getPath(), processId, groupId, artifactId);
    }

    public File zipFromData(String processId, String mandatorId, String groupId, String artifactId) throws IOException {
        DeployServiceImpl.checkPermission("write", "resource");
        DeployServiceImpl.checkPermission("write", "property");
        DeployServiceImpl.checkPermission("write", "script");
        logger.debug("Archiv for {} requested process:{}, group:{}, artifact:{}.", new Object[]{processId, mandatorId, groupId, artifactId});
        DeployTool deploy = new DeployTool();
        deploy.checkArguments(processId, mandatorId, groupId, artifactId);
        Mandator mandator = MandatorServiceImpl.getMandator((BundleContext)this.bundleContext, (String)mandatorId);
        if (mandator == null) {
            throw new IOException("Not found: The requested mandator is not available at this system.");
        }
        return deploy.zipFromDataA(mandator.getPath(), processId, groupId, artifactId);
    }

    public void zipToData(String processId, String mandatorId, String groupId, String artifactId, String zipFileName) throws IOException {
        DeployServiceImpl.checkPermission("write", "resource");
        DeployServiceImpl.checkPermission("write", "property");
        DeployServiceImpl.checkPermission("write", "script");
        logger.debug("Archiv for {} requested process:{}, group:{}, artifact:{}.", new Object[]{processId, mandatorId, groupId, artifactId});
        DeployTool deploy = new DeployTool();
        deploy.checkArguments(processId, mandatorId, groupId, artifactId);
        Mandator mandator = MandatorServiceImpl.getMandator((BundleContext)this.bundleContext, (String)mandatorId);
        if (mandator == null) {
            throw new IOException("Not found: The requested mandator is not available at this system.");
        }
        deploy.zipToDataA(mandator.getPath(), processId, groupId, artifactId, zipFileName);
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    private static void checkPermission(String action, String target) {
    }
}

