/*
 * Decompiled with CFR 0.152.
 */
package org.i3xx.step.due.service.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.i3xx.util.basic.io.FilePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeployTool {
    static final Pattern pattern = Pattern.compile("\\~generated-\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}\\.zip");
    static final Pattern patProcess = Pattern.compile("[A-Za-z0-9+/=_-]{4,}");
    static final Pattern patMandator = Pattern.compile("[A-Za-z][A-Za-z0-9_-]{2,}");
    static final Pattern patGroup = Pattern.compile("[a-z][a-z0-9_-]{3,}");
    static final Pattern patArtifact = Pattern.compile("[a-z][a-z0-9_-]{3,}");

    protected void checkArguments(String processId, String mandatorId, String groupId, String artifactId) {
        if (!patProcess.matcher(processId).matches()) {
            throw new IllegalArgumentException("The process doesn't match (" + processId + ").");
        }
        if (!patMandator.matcher(mandatorId).matches()) {
            throw new IllegalArgumentException("The mandator doesn't match (" + mandatorId + ").");
        }
        if (!patGroup.matcher(groupId).matches()) {
            throw new IllegalArgumentException("The group doesn't match (" + groupId + ").");
        }
        if (!patArtifact.matcher(artifactId).matches()) {
            throw new IllegalArgumentException("The artifact doesn't match (" + artifactId + ").");
        }
    }

    protected void checkArguments(String processId, String groupId, String artifactId) {
        if (!patProcess.matcher(processId).matches()) {
            throw new IllegalArgumentException("The process doesn't match (" + processId + ").");
        }
        if (!patGroup.matcher(groupId).matches()) {
            throw new IllegalArgumentException("The group doesn't match (" + groupId + ").");
        }
        if (!patArtifact.matcher(artifactId).matches()) {
            throw new IllegalArgumentException("The artifact doesn't match (" + artifactId + ").");
        }
    }

    protected File createEmptyZipA(String mandatorPath, String processId, String groupId, String artifactId) throws IOException {
        this.checkArguments(processId, groupId, artifactId);
        FilePath tmpPath = FilePath.append((String[])new String[]{mandatorPath, "temp/deploy", processId});
        FilePath artPath = tmpPath.add(groupId).add(artifactId);
        FilePath fPr = artPath.add("properties");
        FilePath fRs = artPath.add("resources");
        FilePath fJs = artPath.add("js");
        this.buildStruct(fPr, fRs, fJs);
        File zip = this.fileZip(tmpPath);
        this.cleanDir(tmpPath.toFile());
        return zip;
    }

    protected File zipFromDataA(String mandatorPath, String processId, String groupId, String artifactId) throws IOException {
        this.checkArguments(processId, groupId, artifactId);
        FilePath filePath = FilePath.append((String[])new String[]{mandatorPath, "data/page/file/bundle", groupId, artifactId});
        FilePath binPath = FilePath.append((String[])new String[]{mandatorPath, "data/step/bin/bundle", groupId, artifactId});
        FilePath tmpPath = FilePath.append((String[])new String[]{mandatorPath, "temp/deploy", processId});
        FilePath artPath = tmpPath.add(groupId).add(artifactId);
        FilePath fPr = artPath.add("properties");
        FilePath fRs = artPath.add("resources");
        FilePath fJs = artPath.add("js");
        this.buildStruct(fPr, fRs, fJs);
        this.copyDir(filePath.add("properties").toFile(), fPr.toFile());
        this.copyDir(filePath.add("resources").toFile(), fRs.toFile());
        this.copyDir(binPath.add("js").toFile(), fJs.toFile());
        File zip = this.fileZip(tmpPath);
        this.cleanDir(tmpPath.toFile());
        return zip;
    }

    protected void zipToDataA(String mandatorPath, String processId, String groupId, String artifactId, String zipFileName) throws IOException {
        this.checkArguments(processId, groupId, artifactId);
        FilePath filePath = FilePath.append((String[])new String[]{mandatorPath, "data/page/file/bundle", groupId, artifactId});
        FilePath binPath = FilePath.append((String[])new String[]{mandatorPath, "data/step/bin/bundle", groupId, artifactId});
        FilePath tmpPath = FilePath.append((String[])new String[]{mandatorPath, "temp/deploy", processId});
        FilePath artPath = tmpPath.add(groupId).add(artifactId);
        FilePath fPr = artPath.add("properties");
        FilePath fRs = artPath.add("resources");
        FilePath fJs = artPath.add("js");
        this.buildStructA(fPr, fRs, fJs);
        File zip = new File(tmpPath.toFile(), zipFileName);
        this.fileUnzip(zip, tmpPath);
        this.copyDir(fPr.toFile(), filePath.add("properties").toFile());
        this.copyDir(fRs.toFile(), filePath.add("resources").toFile());
        this.copyDir(fJs.toFile(), binPath.add("js").toFile());
        this.cleanDir(tmpPath.toFile());
    }

    protected String getLatestZipFile(String mandatorPath, String processId) {
        ArrayList<String> list = new ArrayList<String>();
        FilePath tmpPath = FilePath.append((String[])new String[]{mandatorPath, "temp/deploy", processId});
        File[] files = tmpPath.toFile().listFiles();
        for (int i = 0; files != null && i < files.length; ++i) {
            String name = files[i].getName();
            if (!pattern.matcher(name).matches()) continue;
            list.add(name);
        }
        Collections.sort(list);
        return list.isEmpty() ? null : (String)list.get(list.size() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long processCRC(String mandatorPath, String processId, String groupId, String artifactId) throws IOException {
        this.checkArguments(processId, groupId, artifactId);
        FilePath filePath = FilePath.append((String[])new String[]{mandatorPath, "data/page/file/bundle", groupId, artifactId});
        FilePath binPath = FilePath.append((String[])new String[]{mandatorPath, "data/step/bin/bundle", groupId, artifactId});
        FilePath fPr = filePath.add("properties");
        FilePath fRs = filePath.add("resources");
        FilePath fJs = binPath.add("js");
        ArrayList<File> list = new ArrayList<File>();
        this.fileWalker(fPr.toFile(), list);
        this.fileWalker(fRs.toFile(), list);
        this.fileWalker(fJs.toFile(), list);
        Collections.sort(list);
        CRC32 crc = new CRC32();
        for (File f : list) {
            FileInputStream is = new FileInputStream(f);
            int len = 0;
            byte[] buf = new byte[1024];
            try {
                while ((len = is.read(buf)) > -1) {
                    crc.update(buf, 0, len);
                }
            }
            finally {
                is.close();
            }
        }
        return crc.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildStruct(FilePath fPr, FilePath fRs, FilePath fJs) throws IOException {
        FileWriter w;
        File txt;
        File tmp = fPr.toFile();
        if (!tmp.exists()) {
            tmp.mkdirs();
        }
        if (tmp.listFiles() == null) {
            txt = new File(tmp, "readme.txt");
            w = new FileWriter(txt);
            try {
                w.write("Put the properties to this directory.\n");
                w.write("The upload will move the files to the right place.\n");
            }
            finally {
                ((Writer)w).close();
            }
        }
        if (!(tmp = fRs.toFile()).exists()) {
            tmp.mkdirs();
        }
        if (tmp.listFiles() == null) {
            txt = new File(tmp, "readme.txt");
            w = new FileWriter(txt);
            try {
                w.write("Put the resources (HTML, CSS, JS) to this directory or any subdirectory.\n");
                w.write("The upload will move the files to the right place.\n");
            }
            finally {
                ((Writer)w).close();
            }
        }
        if (!(tmp = fJs.toFile()).exists()) {
            tmp.mkdirs();
        }
        if (tmp.listFiles() == null) {
            txt = new File(tmp, "readme.txt");
            w = new FileWriter(txt);
            try {
                w.write("Put the server scripts (JS) to this directory or any subdirectory.\n");
                w.write("The upload will move the files to the right place.\n");
            }
            finally {
                ((Writer)w).close();
            }
        }
    }

    private void buildStructA(FilePath fPr, FilePath fRs, FilePath fJs) throws IOException {
        File tmp = fPr.toFile();
        if (!tmp.exists()) {
            tmp.mkdirs();
        }
        if (!(tmp = fRs.toFile()).exists()) {
            tmp.mkdirs();
        }
        if (!(tmp = fJs.toFile()).exists()) {
            tmp.mkdirs();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File fileZip(FilePath tmpPath) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy'-'MM'-'dd'-'HH'-'mm'-'ss");
        String timestamp = sdf.format(new Date());
        String filename = "~generated-" + timestamp + ".zip";
        if (!pattern.matcher(filename).matches()) {
            throw new IOException("The filename '" + filename + "' doesn't match the pattern '" + pattern.toString() + "'.");
        }
        ArrayList<File> list = new ArrayList<File>();
        this.fileWalker(tmpPath.toFile(), list);
        int n = tmpPath.toFile().getAbsolutePath().length();
        File file = tmpPath.add(filename).toFile();
        ZipOutputStream os = new ZipOutputStream(new FileOutputStream(file));
        os.setLevel(-1);
        try {
            for (File f : list) {
                String name = f.getAbsolutePath();
                if (name.length() <= n) continue;
                n = name.charAt(n) == File.separatorChar ? n + 1 : n;
                name = name.substring(n).replace(File.separatorChar, '/');
                ZipEntry e = new ZipEntry(name);
                os.putNextEntry(e);
                FileInputStream in = new FileInputStream(f);
                try {
                    int len = 0;
                    int readCount = 0;
                    byte[] buf = new byte[1024];
                    long time = System.currentTimeMillis();
                    while ((len = ((InputStream)in).read(buf)) > -1) {
                        os.write(buf, 0, len);
                        readCount += len;
                    }
                    e.setSize(readCount);
                    e.setTime(time);
                }
                finally {
                    ((InputStream)in).close();
                }
                os.closeEntry();
            }
        }
        finally {
            os.finish();
            os.close();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileUnzip(File zipFile, FilePath tmpPath) throws ZipException, IOException {
        ZipFile zip = new ZipFile(zipFile);
        try {
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File dest = tmpPath.add(entry.getName()).toFile();
                File path = dest.getParentFile();
                if (path != null && !path.exists()) {
                    path.mkdirs();
                }
                FileOutputStream os = new FileOutputStream(dest);
                InputStream is = zip.getInputStream(entry);
                int len = 0;
                byte[] buf = new byte[1024];
                try {
                    while ((len = is.read(buf)) > -1) {
                        ((OutputStream)os).write(buf, 0, len);
                    }
                }
                finally {
                    try {
                        is.close();
                    }
                    finally {
                        ((OutputStream)os).close();
                    }
                }
            }
        }
        finally {
            zip.close();
        }
    }

    private void fileWalker(File cur, List<File> list) {
        File[] files = cur.listFiles();
        for (int i = 0; files != null && i < files.length; ++i) {
            if (files[i].isFile()) {
                String name = files[i].getName();
                if (pattern.matcher(name).matches()) continue;
                list.add(files[i]);
                continue;
            }
            if (!files[i].isDirectory()) continue;
            this.fileWalker(files[i], list);
        }
    }

    private void copyDir(File fromDir, File toDir) throws IOException {
        String fromName = fromDir.getAbsolutePath();
        String toName = toDir.getAbsolutePath();
        ArrayList<File> list = new ArrayList<File>();
        this.fileWalker(fromDir, list);
        int n = fromName.length();
        for (File src : list) {
            String fn = src.getAbsolutePath();
            if (fn.length() <= n) continue;
            fn = toName + fn.substring(n);
            File dest = new File(fn);
            this.copyFile(src, dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanDir(File file) {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                this.cleanDir(f);
            }
        }
        if (file.isFile() && pattern.matcher(file.getName()).matches()) {
            return;
        }
        file.delete();
        if (file.exists()) {
            try {
                RandomAccessFile raf = new RandomAccessFile(file, "rws");
                try {
                    raf.setLength(0L);
                }
                finally {
                    raf.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            file.deleteOnExit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanResultZip(File file, int skipLatest) {
        if (skipLatest < 1) {
            skipLatest = 1;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                Arrays.sort(files, new Comparator<File>(){

                    @Override
                    public int compare(File a, File b) {
                        return a.getName().compareTo(b.getName());
                    }
                });
            }
            for (int i = 0; files != null && i < files.length - skipLatest; ++i) {
                boolean fd;
                File f = files[i];
                if (!f.isFile() || !pattern.matcher(f.getName()).matches() || (fd = f.delete()) || !file.exists()) continue;
                try {
                    RandomAccessFile raf = new RandomAccessFile(file, "rws");
                    try {
                        raf.setLength(0L);
                    }
                    finally {
                        raf.close();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                file.deleteOnExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File from, File to) throws IOException {
        if (to.exists()) {
            return;
        }
        File path = to.getParentFile();
        if (path != null && !path.exists()) {
            path.mkdirs();
        }
        int len = 0;
        byte[] buf = new byte[1024];
        FileInputStream in = new FileInputStream(from);
        FileOutputStream os = new FileOutputStream(to);
        try {
            while ((len = ((InputStream)in).read(buf)) > -1) {
                ((OutputStream)os).write(buf, 0, len);
            }
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            finally {
                ((OutputStream)os).close();
            }
        }
    }
}

