/*
 * Decompiled with CFR 0.152.
 */
package org.i3xx.step.due.service.impl;

import org.i3xx.step.due.service.impl.PropertyScanner;
import org.i3xx.step.due.service.model.InstPropertyService;
import org.i3xx.step.due.service.model.Session0Service;
import org.i3xx.step.due.service.model.SessionService;
import org.i3xx.step.zero.service.model.mandator.Mandator;
import org.i3xx.util.symbol.service.model.SymbolService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitializeMandatorTrackerImpl
extends ServiceTracker<Mandator, Mandator> {
    static Logger logger = LoggerFactory.getLogger(InitializeMandatorTrackerImpl.class);
    private SessionService sessionService;
    private Session0Service session0Service;
    private InstPropertyService instPropertyService;

    public InitializeMandatorTrackerImpl(BundleContext bundleContext, SessionService sessionService, Session0Service session0Service, InstPropertyService instPropertyService) {
        super(bundleContext, Mandator.class.getName(), null);
        this.sessionService = sessionService;
        this.session0Service = session0Service;
        this.instPropertyService = instPropertyService;
    }

    public Mandator addingService(ServiceReference<Mandator> reference) {
        ServiceReference osr;
        Mandator mandator = (Mandator)this.context.getService(reference);
        if (mandator == null) {
            logger.warn("The mandator service is not available (maybe down or a version conflict).");
        }
        if (!mandator.isInitialized()) {
            logger.warn("The mandator is not initialized (initialize mandator before use).");
            return null;
        }
        logger.debug("adding service, create one session0, initiated by mandator id:{}", (Object)mandator.getId());
        ServiceReference ssr = this.context.getServiceReference(SymbolService.class);
        SymbolService symbolService = (SymbolService)this.context.getService(ssr);
        if (symbolService == null) {
            logger.warn("The symbol service is not available (maybe down or a version conflict).");
        }
        if ((osr = this.context.getServiceReference(Session0Service.class)) == null) {
            logger.debug("The session '0' service is not available (3).");
        } else {
            Session0Service os = (Session0Service)this.context.getService(osr);
            if (os == null) {
                logger.debug("The session '0' service is not available (4).");
            } else {
                this.session0Service = os;
            }
        }
        ServiceReference xsr = this.context.getServiceReference(SessionService.class);
        if (xsr == null) {
            logger.debug("The session service is not available (5).");
        } else {
            SessionService xs = (SessionService)this.context.getService(xsr);
            if (xs == null) {
                logger.debug("The session service is not available (maybe down or a version conflict).");
            } else {
                this.sessionService = xs;
            }
        }
        this.session0Service.initialize(this.sessionService, symbolService, mandator.getId());
        PropertyScanner scan = new PropertyScanner();
        scan.setBundleContext(this.context);
        scan.setInstPropertyService(this.instPropertyService);
        scan.scan(mandator.getId());
        return mandator;
    }
}

