/*
 * Decompiled with CFR 0.152.
 */
package org.i3xx.step.due.service.impl;

import org.i3xx.step.due.service.model.Session0Service;
import org.i3xx.step.due.service.model.SessionService;
import org.i3xx.step.zero.service.model.mandator.Mandator;
import org.i3xx.step.zero.service.model.mandator.MandatorService;
import org.i3xx.util.symbol.service.model.SymbolService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitializeSessionServiceTrackerImpl
extends ServiceTracker<SessionService, SessionService> {
    static Logger logger = LoggerFactory.getLogger(InitializeSessionServiceTrackerImpl.class);
    private Session0Service session0Service;

    public InitializeSessionServiceTrackerImpl(BundleContext bundleContext, Session0Service session0Service) {
        super(bundleContext, SessionService.class.getName(), null);
        this.session0Service = session0Service;
    }

    public SessionService addingService(ServiceReference<SessionService> reference) {
        logger.debug("adding service, create every session0, initiated by session service.");
        SessionService sessionService = (SessionService)this.context.getService(reference);
        ServiceReference ssr = this.context.getServiceReference(SymbolService.class);
        SymbolService symbolService = (SymbolService)this.context.getService(ssr);
        if (symbolService == null) {
            logger.warn("The symbol service is not available (maybe down or a version conflict).");
            return null;
        }
        ServiceReference osr = this.context.getServiceReference(Session0Service.class);
        if (osr == null) {
            logger.debug("The session '0' service is not available (1).");
        } else {
            Session0Service os = (Session0Service)this.context.getService(osr);
            if (os == null) {
                logger.debug("The session '0' service is not available (2).");
            } else {
                this.session0Service = os;
            }
        }
        ServiceReference msr = this.context.getServiceReference(MandatorService.class);
        MandatorService ms = (MandatorService)this.context.getService(msr);
        if (ms == null) {
            logger.warn("The mandator service is not available (maybe down or a version conflict).");
        }
        for (String mandatorId : ms.getMandatorList()) {
            Mandator mandator = ms.getMandator(mandatorId);
            if (mandator == null) {
                logger.warn("The mandator '" + mandatorId + "' is not available on this system.");
            } else {
                logger.debug("The mandator {} is available at the path '{}'.", (Object)mandatorId, (Object)mandator.getPath());
            }
            this.session0Service.initialize(sessionService, symbolService, mandatorId);
        }
        return sessionService;
    }

    public void removedService(ServiceReference<SessionService> reference, SessionService service) {
        logger.debug("removing service, destroy all sessions, initiated by session service.");
        service.destroy(null, null, null);
        this.context.ungetService(reference);
    }
}

