/*
 * Decompiled with CFR 0.152.
 */
package org.i3xx.step.due.service.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.i3xx.step.due.service.model.InstPropertyService;
import org.i3xx.step.zero.service.impl.mandator.MandatorServiceImpl;
import org.i3xx.step.zero.service.impl.mandator.PropertyServiceImpl;
import org.i3xx.step.zero.service.model.mandator.Mandator;
import org.i3xx.step.zero.service.model.mandator.PropertyService;
import org.i3xx.util.basic.io.FilePath;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstPropertyServiceImpl
implements InstPropertyService {
    static Logger logger = LoggerFactory.getLogger(InstPropertyServiceImpl.class);
    private BundleContext bundleContext = null;
    private Map<String, ServiceRegistration<?>> srvRegistration = new HashMap();

    public void startUp() throws IOException {
        logger.info("PropertyService started");
    }

    public void setProperties(String mandatorId, String groupId, String artifactId, String path) throws IOException {
        InstPropertyServiceImpl.checkPermission("write", "property");
        logger.debug("Resource for mandator:{}, group:{} artifact:{} requested '{}'.", new Object[]{mandatorId, groupId, artifactId, path});
        String regKey = mandatorId + "." + groupId + "." + artifactId + "=" + path;
        Mandator mandator = MandatorServiceImpl.getMandator((BundleContext)this.bundleContext, (String)mandatorId);
        if (mandator == null) {
            throw new IOException("Not found: The requested mandator '" + mandatorId + "' is not available at this system.");
        }
        FilePath filePath = FilePath.append((String[])new String[]{mandator.getPath(), "data/page/file/bundle", groupId, artifactId, path});
        File file = filePath.toFile();
        if (!file.exists()) {
            throw new IOException("Not found: The requested property '" + file.getAbsolutePath() + "' is not available at this system.");
        }
        if (!file.isFile()) {
            throw new IOException("Illegal: The requested property '" + file.getAbsolutePath() + "' is not a file.");
        }
        HashMap<String, String> props = new HashMap<String, String>();
        Properties p = this.readPropertyFile(file);
        for (Object k : p.keySet()) {
            String key = (String)k;
            String val = p.getProperty(key);
            props.put(groupId + "." + artifactId + "." + key, val);
        }
        PropertyServiceImpl srv = new PropertyServiceImpl(props);
        Hashtable<String, String> srvDict = new Hashtable<String, String>();
        ((Dictionary)srvDict).put("mandatorId", mandatorId);
        ((Dictionary)srvDict).put("groupId", groupId);
        ((Dictionary)srvDict).put("artifactId", artifactId);
        ((Dictionary)srvDict).put("pathId", path);
        String cName = PropertyService.class.getName();
        try {
            String filter = "(&(mandatorId=" + mandatorId + ")(" + "groupId" + "=" + groupId + ")(" + "artifactId" + "=" + artifactId + ")(" + "pathId" + "=" + path + "))";
            ServiceReference[] refs = this.bundleContext.getServiceReferences(cName, filter);
            if (refs != null) {
                for (ServiceReference ref : refs) {
                    this.bundleContext.ungetService(ref);
                    ServiceRegistration<?> sv = this.srvRegistration.remove(regKey);
                    if (sv == null) continue;
                    sv.unregister();
                }
            }
        }
        catch (InvalidSyntaxException e) {
            logger.error("Error removing service. Proceed...", (Throwable)e);
        }
        ServiceRegistration srg = this.bundleContext.registerService(cName, (Object)srv, srvDict);
        this.srvRegistration.put(regKey, srg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readPropertyFile(File file) throws IOException {
        InstPropertyServiceImpl.checkPermission("read", "property");
        Properties props = new Properties();
        FileInputStream istream = null;
        try {
            istream = new FileInputStream(file);
            props.load(istream);
            istream.close();
        }
        catch (Exception e) {
            if (e instanceof InterruptedIOException || e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            logger.error("Could not read configuration file.", (Throwable)e);
            logger.error("Ignoring configuration file [{}].", (Object)file.getAbsoluteFile());
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (InterruptedIOException ignore) {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable ignore) {}
            }
        }
        return props;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    private static void checkPermission(String action, String target) {
    }
}

