/*
 * Decompiled with CFR 0.152.
 */
package org.i3xx.step.due.service.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.i3xx.step.due.service.model.InstPropertyService;
import org.i3xx.step.zero.service.impl.mandator.MandatorServiceImpl;
import org.i3xx.step.zero.service.model.mandator.Mandator;
import org.i3xx.step.zero.service.model.mandator.MandatorService;
import org.i3xx.util.basic.io.FilePath;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyScanner {
    static Logger logger = LoggerFactory.getLogger(PropertyScanner.class);
    private BundleContext bundleContext = null;
    private InstPropertyService instPropertyService = null;

    public void scanAll() {
        ServiceReference msr = this.bundleContext.getServiceReference(MandatorService.class);
        MandatorService ms = (MandatorService)this.bundleContext.getService(msr);
        if (ms == null) {
            logger.warn("The mandator service is not available (maybe down or a version conflict).");
        }
        for (String mandatorId : ms.getMandatorList()) {
            Mandator mandator = ms.getMandator(mandatorId);
            if (mandator == null) {
                logger.warn("The mandator '" + mandatorId + "' is not available on this system.");
            } else {
                logger.debug("The mandator {} is available at the path '{}'.", (Object)mandatorId, (Object)mandator.getPath());
            }
            this.scan(mandator);
        }
    }

    public void scan(String mandatorId) {
        Mandator mandator = MandatorServiceImpl.getMandator((BundleContext)this.bundleContext, (String)mandatorId);
        if (mandator == null) {
            logger.warn("The mandator '" + mandatorId + "' is not available on this system.");
        } else {
            logger.debug("The mandator {} is available at the path '{}'.", (Object)mandatorId, (Object)mandator.getPath());
        }
        this.scan(mandator);
    }

    private void scan(Mandator mandator) {
        FilePath filePath = FilePath.append((String[])new String[]{mandator.getPath(), "data/page/file/bundle"});
        File file = filePath.toFile();
        ServiceReference psr = this.bundleContext.getServiceReference(InstPropertyService.class);
        if (psr == null) {
            logger.warn("The property service reference is not available.");
        } else {
            InstPropertyService ps = (InstPropertyService)this.bundleContext.getService(psr);
            if (ps == null) {
                logger.warn("The property service is not available (maybe down or a version conflict).");
            } else {
                this.instPropertyService = ps;
            }
        }
        File[] gff = file.listFiles();
        if (gff != null) {
            for (File gf : gff) {
                logger.info("Scan mandator {} group {}", (Object)mandator.getId(), (Object)gf.getName());
                File[] aff = gf.listFiles();
                if (aff == null) continue;
                for (File af : aff) {
                    logger.info("Scan mandator {} group {} artifact {}", new Object[]{mandator.getId(), gf.getName(), af.getName()});
                    File d = new File(af, "properties");
                    if (!d.exists() || !d.isDirectory()) continue;
                    ArrayList<String> list = new ArrayList<String>();
                    this.search(d, d.getName(), list);
                    String mandatorId = mandator.getId();
                    String groupId = gf.getName();
                    String artifactId = af.getName();
                    for (String pathId : list) {
                        try {
                            this.instPropertyService.setProperties(mandatorId, groupId, artifactId, pathId);
                        }
                        catch (IOException e) {
                            logger.warn("", (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    private void search(File file, String parent, List<String> list) {
        if (file.isFile()) {
            list.add(parent);
            return;
        }
        File[] ff = file.listFiles();
        if (ff == null) {
            return;
        }
        for (File f : ff) {
            this.search(f, parent + "/" + f.getName(), list);
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public InstPropertyService getInstPropertyService() {
        return this.instPropertyService;
    }

    public void setInstPropertyService(InstPropertyService instPropertyService) {
        this.instPropertyService = instPropertyService;
    }
}

