/*
 * Decompiled with CFR 0.152.
 */
package org.i3xx.step.due.service.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.Map;
import org.i3xx.step.due.service.model.ResourceService;
import org.i3xx.step.zero.service.impl.mandator.MandatorServiceImpl;
import org.i3xx.step.zero.service.model.mandator.Mandator;
import org.i3xx.util.basic.io.FilePath;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceServiceImpl
implements ResourceService {
    static Logger logger = LoggerFactory.getLogger(ResourceServiceImpl.class);
    private BundleContext bundleContext = null;

    public void startUp() throws IOException {
        logger.info("ResourceService started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getResource(String mandatorId, String groupId, String artifactId, String path, int type, Map<String, String> props) throws IOException {
        ResourceServiceImpl.checkPermission("read", "resource");
        logger.debug("Resource for {} requested '{}'.", (Object)mandatorId, (Object)path);
        Mandator mandator = MandatorServiceImpl.getMandator((BundleContext)this.bundleContext, (String)mandatorId);
        if (mandator == null) {
            throw new IOException("Not found: The requested mandator '" + mandatorId + "' is not available at this system.");
        }
        FilePath filePath = FilePath.append((String[])new String[]{mandator.getPath(), "data/page/file/bundle", groupId, artifactId, path});
        File file = filePath.toFile();
        if (!file.exists()) {
            logger.trace("The resource '{}' is not available.", (Object)file.getAbsolutePath());
            throw new IOException("Not found: The requested resource '" + file.getName() + "' is not available at this system.");
        }
        if (!file.isFile()) {
            logger.trace("The resource '{}' is no file.", (Object)file.getAbsolutePath());
            throw new IOException("Illegal: The requested resource '" + file.getName() + "' is not a file.");
        }
        FileReader in = new FileReader(file);
        StringWriter out = new StringWriter();
        int c = 0;
        char[] cbuf = new char[512];
        try {
            while ((c = in.read(cbuf)) > -1) {
                out.write(cbuf, 0, c);
            }
        }
        finally {
            in.close();
            out.close();
        }
        return out.toString();
    }

    @Override
    public InputStream getResourceAsStream(String mandatorId, String groupId, String artifactId, String path, int type, Map<String, String> props) throws IOException {
        ResourceServiceImpl.checkPermission("read", "resource");
        logger.debug("Resource for {} requested '{}'.", (Object)mandatorId, (Object)path);
        Mandator mandator = MandatorServiceImpl.getMandator((BundleContext)this.bundleContext, (String)mandatorId);
        if (mandator == null) {
            throw new IOException("Not found: The requested mandator '" + mandatorId + "' is not available at this system.");
        }
        FilePath filePath = FilePath.append((String[])new String[]{mandator.getPath(), "data/page/file/bundle", groupId, artifactId, path});
        File file = filePath.toFile();
        if (!file.exists()) {
            logger.trace("The resource '{}' is not available.", (Object)file.getAbsolutePath());
            throw new IOException("Not found: The requested resource '" + file.getName() + "' is not available at this system.");
        }
        if (!file.isFile()) {
            logger.trace("The resource '{}' is no file.", (Object)file.getAbsolutePath());
            throw new IOException("Illegal: The requested resource '" + file.getName() + "' is not a file.");
        }
        return new FileInputStream(file);
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    private static void checkPermission(String action, String target) {
    }
}

