/*
 * Decompiled with CFR 0.152.
 */
package org.i3xx.step.due.service.impl;

import java.io.IOException;
import java.util.HashMap;
import org.apache.velocity.app.VelocityEngine;
import org.i3xx.step.due.core.impl.SessionException;
import org.i3xx.step.due.core.impl.activator.DueLogChute;
import org.i3xx.step.due.service.model.Session;
import org.i3xx.step.due.service.model.Session0Service;
import org.i3xx.step.due.service.model.SessionService;
import org.i3xx.util.symbol.service.model.SymbolService;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session0ServiceImpl
implements Session0Service {
    static Logger logger = LoggerFactory.getLogger(Session0ServiceImpl.class);
    private BundleContext bundleContext = null;

    public void startUp() throws IOException {
        logger.info("Session0Service started");
    }

    public void initialize(SessionService sessionService, SymbolService symbolService, String mandatorId) {
        VelocityEngine ve;
        logger.info("Create the session '0' for the mandator {}", (Object)mandatorId);
        boolean created = false;
        Session session = null;
        String sessionId = "0";
        session = sessionService.getSession(null, mandatorId, sessionId);
        if (session == null) {
            HashMap<String, String> params = new HashMap<String, String>();
            try {
                session = sessionService.createSession(null, mandatorId, -1L, sessionId, params);
            }
            catch (SessionException e) {
                logger.warn("The session service is not initialized properly.", (Throwable)e);
                e.printStackTrace();
            }
            created = true;
        }
        VelocityEngine velocityEngine = ve = created ? null : (VelocityEngine)session.getValue("engine.velocity");
        if (ve == null) {
            ve = new VelocityEngine();
            ve.setProperty("runtime.log.logsystem", (Object)new DueLogChute());
            ve.init();
            session.setValue("engine.velocity", ve);
        }
        if (session.getValue("engine.base.index") == null) {
            try {
                int index = symbolService.getSymbol(mandatorId);
                session.setValue("engine.base.index", new Integer(index));
            }
            catch (IOException e) {
                logger.warn("The 'engine.base.index' is not set properly.", (Throwable)e);
            }
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    private static void checkPermission(String action, String target) {
    }
}

