/*
 * Decompiled with CFR 0.152.
 */
package org.i3xx.step.due.service.impl;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.i3xx.step.due.service.model.Session;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionImpl
implements Session {
    static Logger logger = LoggerFactory.getLogger(SessionImpl.class);
    private BundleContext bundleContext = null;
    private final String sessionId;
    private final String mandator;
    private final long startTime;
    private final long timeout;
    private final Map<String, Object> data;
    private boolean alive;

    public SessionImpl(String sessionId, String mandator, long timeout) {
        this.sessionId = sessionId;
        this.mandator = mandator;
        this.startTime = System.currentTimeMillis();
        this.timeout = timeout;
        this.data = new LinkedHashMap<String, Object>();
        this.alive = true;
    }

    @Override
    public String getSessionId() {
        SessionImpl.checkPermission("read", "session-id");
        return this.sessionId;
    }

    @Override
    public String getMandator() {
        SessionImpl.checkPermission("read", "mandator-id");
        return this.mandator;
    }

    @Override
    public Set<String> getKeys() {
        SessionImpl.checkPermission("read", "key");
        return this.data.keySet();
    }

    @Override
    public Object getValue(String key) {
        SessionImpl.checkPermission("read", "value");
        return this.data.get(key);
    }

    @Override
    public void setValue(String key, Object value) {
        SessionImpl.checkPermission("write", "value");
        this.data.put(key, value);
    }

    @Override
    public void clearData() {
        SessionImpl.checkPermission("write", "cleanup");
        this.data.clear();
    }

    @Override
    public long getStartTime() {
        SessionImpl.checkPermission("read", "starttime");
        return this.startTime;
    }

    @Override
    public long getTimeout() {
        SessionImpl.checkPermission("read", "timeout");
        return this.timeout;
    }

    @Override
    public void destroy() {
        SessionImpl.checkPermission("exec", "destroy");
        this.alive = false;
        this.data.clear();
        ServiceReference eventAdmRef = this.bundleContext.getServiceReference(EventAdmin.class);
        if (eventAdmRef != null) {
            EventAdmin eventAdmin = (EventAdmin)this.bundleContext.getService(eventAdmRef);
            if (eventAdmin != null) {
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("mandatorId", this.mandator);
                data.put("sessionId", this.sessionId);
                Event event = new Event("session-destroy", data);
                eventAdmin.sendEvent(event);
            }
        } else {
            logger.debug("The EventAdminService is not present.");
        }
    }

    @Override
    public boolean isValid() {
        SessionImpl.checkPermission("read", "is-valid");
        return this.alive && (this.timeout < 0L || System.currentTimeMillis() - this.timeout < this.startTime);
    }

    @Override
    public boolean isAlive() {
        SessionImpl.checkPermission("read", "is-alive");
        return this.alive;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    private static void checkPermission(String action, String target) {
    }
}

