/*
 * Decompiled with CFR 0.152.
 */
package org.i3xx.step.due.service.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.i3xx.step.due.core.impl.SessionException;
import org.i3xx.step.due.service.impl.SessionImpl;
import org.i3xx.step.due.service.model.Session;
import org.i3xx.step.due.service.model.SessionService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionServiceImpl
implements SessionService,
EventHandler {
    static Logger logger = LoggerFactory.getLogger(SessionServiceImpl.class);
    private BundleContext bundleContext = null;
    private Map<String, ServiceRegistration<?>> regList = new HashMap();

    public void startUp() throws IOException {
        logger.info("SessionService started");
    }

    public void handleEvent(Event event) {
        logger.trace("Event {} received", (Object)event.getTopic());
        if (event.getTopic() != null && event.getTopic().equals("session-destroy")) {
            String mandatorId = (String)event.getProperty("mandatorId");
            String sessionId = (String)event.getProperty("sessionId");
            this.destroy(null, mandatorId, sessionId);
        }
    }

    @Override
    public Session createSession(String cert, String mandatorId, long timeout, String sessionId, Map<String, String> params) throws SessionException {
        SessionServiceImpl.checkPermission("create", "session");
        Session session = null;
        if (this.exists(mandatorId, sessionId)) {
            session = this.getSession(mandatorId, sessionId);
        } else {
            logger.debug("Create session:{} mandator:{} timeout:{}", new Object[]{sessionId, mandatorId, timeout});
            session = new SessionImpl(sessionId, mandatorId, timeout);
            ((SessionImpl)session).setBundleContext(this.bundleContext);
            String[] clazzes = new String[]{Session.class.getName()};
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            properties.put("mandatorId", mandatorId);
            properties.put("useraccessId", Boolean.TRUE);
            properties.put("sessionId", sessionId);
            properties.putAll(params);
            this.regList.put(sessionId, this.bundleContext.registerService(clazzes, (Object)session, properties));
        }
        return session;
    }

    private Session getSession(String mandatorId, String sessionId) {
        SessionServiceImpl.checkPermission("read", "session");
        Session session = null;
        try {
            String clazz = Session.class.getName();
            String filter = "(&(objectClass=" + Session.class.getName() + ")(" + "mandatorId" + "=" + mandatorId + ")(" + "sessionId" + "=" + sessionId + "))";
            ServiceReference[] srv = this.bundleContext.getServiceReferences(clazz, filter);
            logger.debug("Get session session:{} mandator:{} refs:{}", new Object[]{sessionId, mandatorId, srv == null ? -1 : srv.length});
            if (srv != null && srv.length > 0) {
                session = (Session)this.bundleContext.getService(srv[0]);
            }
        }
        catch (InvalidSyntaxException e) {
            logger.error("The syntax of the filter is not valid.", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("The session search results in an exception.", (Throwable)e);
        }
        return session;
    }

    @Override
    public ServiceReference<?>[] getSessionReference(String mandatorId, String sessionId) {
        SessionServiceImpl.checkPermission("read", "session");
        ServiceReference[] refs = null;
        try {
            String clazz = Session.class.getName();
            String filter = "(&(objectClass=" + Session.class.getName() + ")";
            if (mandatorId != null) {
                filter = filter + "(mandatorId=" + mandatorId + ")";
            }
            if (sessionId != null) {
                filter = filter + "(sessionId=" + sessionId + ")";
            }
            filter = filter + ")";
            refs = this.bundleContext.getServiceReferences(clazz, filter);
            logger.debug("Get session service reference session:{} mandator:{} refs:{}", new Object[]{sessionId, mandatorId, refs == null ? -1 : refs.length});
        }
        catch (InvalidSyntaxException e) {
            logger.error("The syntax of the filter is not valid.", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("The session search results in an exception.", (Throwable)e);
        }
        return refs;
    }

    @Override
    public Session getSession(String cert, String mandatorId, String sessionId) {
        SessionServiceImpl.checkPermission("read", "session");
        return this.getSession(mandatorId, sessionId);
    }

    @Override
    public boolean exists(String mandatorId, String sessionId) {
        SessionServiceImpl.checkPermission("read", "session");
        ServiceReference<?>[] refs = this.getSessionReference(mandatorId, sessionId);
        return refs != null && refs.length > 0;
    }

    @Override
    public boolean destroy(String cert, String mandatorId, String sessionId) {
        ServiceReference<?>[] refs;
        SessionServiceImpl.checkPermission("destroy", "session");
        if (sessionId == null) {
            SessionServiceImpl.checkPermission("destroy", "sessions");
        }
        if (sessionId == null && mandatorId == null) {
            SessionServiceImpl.checkPermission("destroy", "all-sessions");
        }
        if ((refs = this.getSessionReference(mandatorId, sessionId)) == null || refs.length == 0) {
            return false;
        }
        boolean flag = true;
        for (ServiceReference<?> r : refs) {
            ServiceRegistration<?> reg;
            Session session = (Session)this.bundleContext.getService(r);
            if (session == null) {
                logger.debug("The session is not avaialble (null).");
                continue;
            }
            if (session.isAlive()) {
                String mn = session.getMandator();
                String id = session.getSessionId();
                session.destroy();
                logger.debug("The session '{}' of '{}' is destroyed.", (Object)mn, (Object)id);
            }
            if (!this.bundleContext.ungetService(r)) {
                flag = false;
                logger.warn("The session '{}' of the mandator '{}' is not removed properly.", (Object)mandatorId, (Object)sessionId);
            }
            if ((reg = this.regList.remove(session.getSessionId())) == null) continue;
            reg.unregister();
        }
        return flag;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public static Session getSession(BundleContext bundleContext, String cert, String mandatorId, String sessionId) {
        SessionServiceImpl.checkPermission("read", "session");
        Session session = null;
        try {
            String clazz = Session.class.getName();
            String filter = "(&(objectClass=" + Session.class.getName() + ")(" + "mandatorId" + "=" + mandatorId + ")(" + "sessionId" + "=" + sessionId + "))";
            ServiceReference[] srv = bundleContext.getServiceReferences(clazz, filter);
            logger.trace("Search session service reference session:{} mandator:{} result:{}", new Object[]{sessionId, mandatorId, srv == null ? -1 : srv.length});
            if (srv != null && srv.length > 0) {
                session = (Session)bundleContext.getService(srv[0]);
            }
        }
        catch (InvalidSyntaxException e) {
            logger.error("The syntax of the filter is not valid.", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("The session search results in an exception.", (Throwable)e);
        }
        return session;
    }

    private static void checkPermission(String action, String target) {
    }
}

