/*
 * Decompiled with CFR 0.152.
 */
package org.i3xx.step.due.service.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.i3xx.step.due.service.impl.SessionServiceImpl;
import org.i3xx.step.due.service.model.Session;
import org.i3xx.step.due.service.model.VelocityService;
import org.i3xx.step.zero.service.impl.mandator.MandatorServiceImpl;
import org.i3xx.step.zero.service.model.mandator.Mandator;
import org.i3xx.util.basic.io.FilePath;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VelocityServiceImpl
implements VelocityService {
    static Logger logger = LoggerFactory.getLogger(VelocityServiceImpl.class);
    private BundleContext bundleContext = null;

    public void startUp() throws IOException {
        logger.info("VelocityService started");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getResource(String mandatorId, String groupId, String artifactId, String path, int type, Map<String, String> props) throws IOException {
        VelocityServiceImpl.checkPermission("read", "resource");
        logger.debug("Resource for {} requested '{}'.", (Object)mandatorId, (Object)path);
        Mandator mandator = MandatorServiceImpl.getMandator((BundleContext)this.bundleContext, (String)mandatorId);
        if (mandator == null) {
            throw new IOException("Not found: The requested mandator '" + mandatorId + "' is not available at this system.");
        }
        FilePath filePath = FilePath.append((String[])new String[]{mandator.getPath(), "data/page/file/bundle", groupId, artifactId, path});
        File file = filePath.toFile();
        if (!file.exists()) {
            logger.trace("The resource '{}' is not available.", (Object)file.getAbsolutePath());
            throw new IOException("Not found: The requested resource '" + file.getName() + "' is not available at this system.");
        }
        if (!file.isFile()) {
            logger.trace("The resource '{}' is no file.", (Object)file.getAbsolutePath());
            throw new IOException("Illegal: The requested resource '" + file.getName() + "' is not a file.");
        }
        Session session0 = SessionServiceImpl.getSession(this.bundleContext, null, mandatorId, "0");
        if (session0 == null) {
            throw new IOException("The session(0) service is not available for the mandator '" + mandatorId + "'.");
        }
        VelocityEngine ve = (VelocityEngine)session0.getValue("engine.velocity");
        if (ve == null) {
            throw new IOException("The velocity engine is not available for the mandator '" + mandatorId + "'.");
        }
        VelocityContext context = new VelocityContext();
        context.put("subject.mandator.id", (Object)mandatorId);
        context.put("subject.group.id", (Object)groupId);
        context.put("subject.artifact.id", (Object)artifactId);
        for (Map.Entry<String, String> e : props.entrySet()) {
            context.put(e.getKey(), (Object)e.getValue());
        }
        FileReader in = new FileReader(file);
        StringWriter out = new StringWriter();
        try {
            boolean f = ve.evaluate((Context)context, (Writer)out, "VelocityServiceImpl", (Reader)in);
            if (!f) {
                logger.debug("Velocity for '{}' request fail at template '{}'.", (Object)mandatorId, (Object)file.getAbsolutePath());
            }
        }
        finally {
            in.close();
            out.close();
        }
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getResourceAsStream(String mandatorId, String groupId, String artifactId, String path, int type, Map<String, String> props) throws IOException {
        VelocityServiceImpl.checkPermission("read", "resource");
        logger.debug("Resource for {} requested '{}'.", (Object)mandatorId, (Object)path);
        Mandator mandator = MandatorServiceImpl.getMandator((BundleContext)this.bundleContext, (String)mandatorId);
        if (mandator == null) {
            throw new IOException("Not found: The requested mandator '" + mandatorId + "' is not available at this system.");
        }
        FilePath filePath = FilePath.append((String[])new String[]{mandator.getPath(), "data/page/file/bundle", groupId, artifactId, path});
        File file = filePath.toFile();
        if (!file.exists()) {
            logger.trace("The resource '{}' is not available.", (Object)file.getAbsolutePath());
            throw new IOException("Not found: The requested resource '" + file.getName() + "' is not available at this system.");
        }
        if (!file.isFile()) {
            logger.trace("The resource '{}' is no file.", (Object)file.getAbsolutePath());
            throw new IOException("Illegal: The requested resource '" + file.getName() + "' is not a file.");
        }
        Session session0 = SessionServiceImpl.getSession(this.bundleContext, null, mandatorId, "0");
        if (session0 == null) {
            throw new IOException("The session(0) service is not available for the mandator '" + mandatorId + "'.");
        }
        VelocityEngine ve = (VelocityEngine)session0.getValue("engine.velocity");
        if (ve == null) {
            throw new IOException("The velocity engine is not available for the mandator '" + mandatorId + "'.");
        }
        VelocityContext context = new VelocityContext();
        context.put("subject_mandator_id", (Object)mandatorId);
        context.put("subject_group_id", (Object)groupId);
        context.put("subject_artifact_id", (Object)artifactId);
        for (Map.Entry<String, String> e : props.entrySet()) {
            context.put(e.getKey(), (Object)e.getValue());
        }
        FileReader in = new FileReader(file);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        OutputStreamWriter out = new OutputStreamWriter(bout);
        try {
            boolean f = ve.evaluate((Context)context, (Writer)out, "VelocityServiceImpl", (Reader)in);
            if (!f) {
                logger.debug("Velocity for '{}' request fail at template '{}'.", (Object)mandatorId, (Object)file.getAbsolutePath());
            }
        }
        finally {
            in.close();
            out.close();
        }
        return new ByteArrayInputStream(bout.toByteArray());
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    private static void checkPermission(String action, String target) {
    }
}

