/*
 * Decompiled with CFR 0.152.
 */
package org.i3xx.step.zero.security.impl.shiro;

import java.io.Serializable;
import java.util.Properties;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.cache.MemoryConstrainedCacheManager;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.subject.Subject;
import org.i3xx.step.zero.security.NaFactory;
import org.i3xx.step.zero.security.impl.shiro.NaMyRealm;
import org.i3xx.step.zero.security.impl.shiro.NaSessionImpl;
import org.i3xx.step.zero.security.impl.shiro.NaSubjectImpl;
import org.i3xx.step.zero.security.model.NaSession;
import org.i3xx.step.zero.security.model.NaSubject;

public class NaFactoryImpl
implements NaFactory {
    public void setSecurityManager(Properties props) {
        if (props == null) {
            // empty if block
        }
        NaMyRealm realm = new NaMyRealm();
        DefaultSecurityManager securityManager = new DefaultSecurityManager((Realm)realm);
        SecurityUtils.setSecurityManager((SecurityManager)securityManager);
        MemoryConstrainedCacheManager cacheManager = new MemoryConstrainedCacheManager();
        securityManager.setCacheManager((CacheManager)cacheManager);
    }

    public NaSubject createSubject(Serializable sessionId) {
        Subject requestSubject = new Subject.Builder().sessionId(sessionId).buildSubject();
        NaSubjectImpl subject = new NaSubjectImpl(requestSubject);
        return subject;
    }

    public NaSubject getSubject() {
        NaSubjectImpl subject = new NaSubjectImpl(SecurityUtils.getSubject());
        return subject;
    }

    public NaSession getSession() {
        NaSessionImpl session = new NaSessionImpl(SecurityUtils.getSubject().getSession());
        return session;
    }
}

