/*
 * Decompiled with CFR 0.152.
 */
package org.i3xx.step.zero.security.impl.shiro;

import org.apache.shiro.authc.AccountException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAccount;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.crypto.SecureRandomNumberGenerator;
import org.apache.shiro.crypto.hash.Sha256Hash;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.ByteSource;
import org.apache.shiro.util.SimpleByteSource;

public class NaMyRealm
extends AuthorizingRealm {
    private String _salt;
    private String _hash;

    public NaMyRealm() {
        String hash;
        String username = "admin";
        String plainTextPassword = "ffpbanm";
        SecureRandomNumberGenerator rng = new SecureRandomNumberGenerator();
        ByteSource salt = rng.nextBytes();
        this._salt = salt.toBase64();
        this._hash = hash = new Sha256Hash((Object)plainTextPassword, (Object)this._salt, 1024).toBase64();
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        String username = (String)this.getAvailablePrincipal(principals);
        return this.getAccount(username, null);
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        UsernamePasswordToken upToken = (UsernamePasswordToken)token;
        return this.getAccount(upToken.getUsername(), upToken.getCredentials());
    }

    protected SimpleAccount getAccount(String username, Object credentials) {
        System.out.println("get account user: " + username);
        if (username == null) {
            throw new AccountException("Null usernames are not allowed by this realm.");
        }
        String hash = this._hash;
        SimpleByteSource salt = new SimpleByteSource(this._salt);
        SimpleAccount account = new SimpleAccount((Object)username, (Object)hash, (ByteSource)salt, this.getName());
        account.addRole("user");
        account.addRole("admin");
        account.addStringPermission("blogEntry:edit");
        account.addStringPermission("printer:print:laserjet");
        account.setCredentials(credentials);
        return account;
    }
}

