/*
 * Decompiled with CFR 0.152.
 */
package org.i3xx.step.zero.security.impl.shiro;

import java.util.Collection;
import java.util.List;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.i3xx.step.zero.security.impl.shiro.NaPrincipalCollectionImpl;
import org.i3xx.step.zero.security.impl.shiro.NaSessionImpl;
import org.i3xx.step.zero.security.model.NaAuthenticationToken;
import org.i3xx.step.zero.security.model.NaPrincipalCollection;
import org.i3xx.step.zero.security.model.NaSession;
import org.i3xx.step.zero.security.model.NaSubject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NaSubjectImpl
implements NaSubject {
    private Subject subject;

    public NaSubjectImpl(Subject subject) {
        this.subject = subject;
    }

    @Override
    public Object getPrincipal() {
        return this.subject.getPrincipal();
    }

    @Override
    public NaPrincipalCollection getPrincipals() {
        return new NaPrincipalCollectionImpl(this.subject.getPrincipals());
    }

    @Override
    public boolean isPermitted(String permission) {
        return this.subject.isPermitted(permission);
    }

    @Override
    public boolean[] isPermitted(String ... permissions) {
        return this.subject.isPermitted(permissions);
    }

    @Override
    public boolean isPermittedAll(String ... permissions) {
        return this.subject.isPermittedAll(permissions);
    }

    @Override
    public void checkPermission(String permission) throws RuntimeException {
        this.subject.checkPermission(permission);
    }

    @Override
    public void checkPermissions(String ... permissions) throws RuntimeException {
        this.subject.checkPermissions(permissions);
    }

    @Override
    public boolean hasRole(String roleIdentifier) {
        return this.subject.hasRole(roleIdentifier);
    }

    @Override
    public boolean[] hasRoles(List<String> roleIdentifiers) {
        return this.subject.hasRoles(roleIdentifiers);
    }

    @Override
    public boolean hasAllRoles(Collection<String> roleIdentifiers) {
        return this.subject.hasAllRoles(roleIdentifiers);
    }

    @Override
    public void checkRole(String roleIdentifier) throws RuntimeException {
        this.subject.checkRole(roleIdentifier);
    }

    @Override
    public void checkRoles(Collection<String> roleIdentifiers) throws RuntimeException {
        this.subject.checkRoles(roleIdentifiers);
    }

    @Override
    public void checkRoles(String ... roleIdentifiers) throws RuntimeException {
        this.subject.checkRoles(roleIdentifiers);
    }

    @Override
    public void login(NaAuthenticationToken token) {
        this.subject.login((AuthenticationToken)token.getToken());
    }

    @Override
    public boolean isAuthenticated() {
        return this.subject.isAuthenticated();
    }

    @Override
    public boolean isRemembered() {
        return this.subject.isRemembered();
    }

    @Override
    public NaSession getSession() {
        return new NaSessionImpl(this.subject.getSession());
    }

    @Override
    public NaSession getSession(boolean create) {
        return new NaSessionImpl(this.subject.getSession(create));
    }

    @Override
    public void logout() {
        this.subject.logout();
    }

    @Override
    public void execute(Runnable runnable) {
        this.subject.execute(runnable);
    }

    @Override
    public Runnable associateWith(Runnable runnable) {
        return this.subject.associateWith(runnable);
    }

    @Override
    public void runAs(NaPrincipalCollection principals) throws NullPointerException, IllegalStateException {
        this.subject.runAs((PrincipalCollection)principals.getPrincipals());
    }

    @Override
    public boolean isRunAs() {
        return this.subject.isRunAs();
    }

    @Override
    public NaPrincipalCollection getPreviousPrincipals() {
        return new NaPrincipalCollectionImpl(this.subject.getPreviousPrincipals());
    }

    @Override
    public NaPrincipalCollection releaseRunAs() {
        return new NaPrincipalCollectionImpl(this.subject.releaseRunAs());
    }

    public int hashCode() {
        return this.subject.hashCode();
    }

    public boolean equals(Object obj) {
        return this.subject.equals(obj);
    }

    public String toString() {
        return this.subject.toString();
    }
}

