/*
 * Decompiled with CFR 0.152.
 */
package org.i3xx.step.zero.service.impl.cx;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.i3xx.step.zero.service.model.cx.Context;

public class ContextImpl
implements Context {
    private final BigInteger id;
    private final Map<String, Object> attributes;
    private int counter;

    public ContextImpl() {
        UUID ui = UUID.randomUUID();
        this.id = BigInteger.valueOf(ui.getMostSignificantBits()).shiftLeft(64).or(BigInteger.valueOf(ui.getLeastSignificantBits()));
        this.attributes = new HashMap<String, Object>();
        this.counter = 0;
    }

    public BigInteger getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int bind() {
        BigInteger bigInteger = this.id;
        synchronized (bigInteger) {
            ++this.counter;
        }
        return this.counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unbind() {
        BigInteger bigInteger = this.id;
        synchronized (bigInteger) {
            --this.counter;
            if (this.counter == Integer.MAX_VALUE) {
                this.counter = 0;
            }
        }
        return this.counter;
    }

    public String[] getAttributeNames() {
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public Object removeAttribute(String name) {
        return this.attributes.remove(name);
    }

    public void clearAttributes() {
        this.attributes.clear();
    }
}

