/*
 * Decompiled with CFR 0.152.
 */
package org.i3xx.step.zero.service.impl.cx;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.i3xx.step.zero.service.impl.cx.ContextImpl;
import org.i3xx.step.zero.service.model.cx.Context;
import org.i3xx.step.zero.service.model.cx.ContextProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextProviderImpl
implements ContextProvider {
    private static Logger logger = LoggerFactory.getLogger(ContextProviderImpl.class);
    private BundleContext bundleContext;
    private Map<BigInteger, ServiceRegistration<?>> services;

    public ContextProviderImpl() {
        this.setBundleContext(null);
        this.services = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Context bind(Map<String, Object> properties) {
        ServiceReference ref;
        String clazz = Context.class.getName();
        String filter = ContextProviderImpl.getFilter(properties);
        ServiceReference[] refs = null;
        try {
            refs = this.bundleContext.getServiceReferences(clazz, filter);
        }
        catch (InvalidSyntaxException e) {
            logger.warn("bind: The filter is not matching.", (Throwable)e);
        }
        Context context = null;
        ServiceReference[] arr$ = refs;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (context = (Context)this.bundleContext.getService(ref = arr$[i$])) == null; ++i$) {
        }
        Hashtable<String, Object> prop = new Hashtable<String, Object>();
        prop.putAll(properties);
        Map<BigInteger, ServiceRegistration<?>> map = this.services;
        synchronized (map) {
            if (context == null) {
                context = new ContextImpl();
                prop.put("contextId", context.getId());
                this.services.put(context.getId(), this.bundleContext.registerService(clazz, (Object)context, prop));
            }
            context.bind();
        }
        return context;
    }

    @Override
    public Context find(Map<String, Object> properties) {
        ServiceReference ref;
        String clazz = Context.class.getName();
        String filter = ContextProviderImpl.getFilter(properties);
        ServiceReference[] refs = null;
        try {
            refs = this.bundleContext.getServiceReferences(clazz, filter);
        }
        catch (InvalidSyntaxException e) {
            logger.warn("find: The filter is not matching.", (Throwable)e);
        }
        Context context = null;
        ServiceReference[] arr$ = refs;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (context = (Context)this.bundleContext.getService(ref = arr$[i$])) == null; ++i$) {
        }
        return context;
    }

    @Override
    public Context[] findAll(Map<String, Object> properties) {
        String clazz = Context.class.getName();
        String filter = ContextProviderImpl.getFilter(properties);
        ServiceReference[] refs = null;
        try {
            refs = this.bundleContext.getServiceReferences(clazz, filter);
        }
        catch (InvalidSyntaxException e) {
            logger.warn("find: The filter is not matching.", (Throwable)e);
        }
        ArrayList<Context> context = new ArrayList<Context>();
        if (refs != null) {
            for (ServiceReference ref : refs) {
                context.add((Context)this.bundleContext.getService(ref));
            }
        }
        return context.toArray(new Context[context.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free(Map<String, Object> properties) {
        String clazz = Context.class.getName();
        String filter = ContextProviderImpl.getFilter(properties);
        ServiceReference[] refs = null;
        try {
            refs = this.bundleContext.getServiceReferences(clazz, filter);
        }
        catch (InvalidSyntaxException e) {
            logger.warn("find: The filter is not matching.", (Throwable)e);
        }
        Context context = null;
        for (ServiceReference ref : refs) {
            context = (Context)this.bundleContext.getService(ref);
            if (context == null) continue;
            Map<BigInteger, ServiceRegistration<?>> map = this.services;
            synchronized (map) {
                int c = context.unbind();
                if (c <= 0 && this.services.containsKey(context.getId())) {
                    this.services.remove(context.getId()).unregister();
                }
                break;
            }
        }
    }

    @Override
    public void kill(Map<String, Object> properties) {
        String clazz = Context.class.getName();
        String filter = ContextProviderImpl.getFilter(properties);
        ServiceReference[] refs = null;
        try {
            refs = this.bundleContext.getServiceReferences(clazz, filter);
        }
        catch (InvalidSyntaxException e) {
            logger.warn("find: The filter is not matching.", (Throwable)e);
        }
        Context context = null;
        if (refs != null) {
            for (ServiceReference ref : refs) {
                context = (Context)this.bundleContext.getService(ref);
                if (!this.services.containsKey(context.getId())) continue;
                this.services.remove(context.getId()).unregister();
            }
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    private static String getFilter(Map<String, Object> properties) {
        StringBuffer filter = new StringBuffer();
        filter.append("(&");
        for (Map.Entry<String, Object> e : properties.entrySet()) {
            filter.append('(');
            filter.append(e.getKey());
            filter.append('=');
            filter.append(e.getValue());
            filter.append(')');
        }
        filter.append(')');
        String result = filter.toString();
        logger.debug("Searching with filter {}", (Object)result);
        return result;
    }

    public static Context find(BundleContext bundleContext, Map<String, Object> properties) {
        String clazz = Context.class.getName();
        String filter = ContextProviderImpl.getFilter(properties);
        ServiceReference[] refs = null;
        try {
            refs = bundleContext.getServiceReferences(clazz, filter);
        }
        catch (InvalidSyntaxException e) {
            logger.warn("find: The filter is not matching.", (Throwable)e);
        }
        Context context = null;
        if (refs != null) {
            ServiceReference ref;
            ServiceReference[] arr$ = refs;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (context = (Context)bundleContext.getService(ref = arr$[i$])) == null; ++i$) {
            }
        }
        return context;
    }
}

