/*
 * Decompiled with CFR 0.152.
 */
package org.i3xx.step.zero.service.impl.mandator;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.i3xx.step.zero.service.model.mandator.Mandator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MandatorImpl
implements Mandator,
ManagedService {
    final Logger logger = LoggerFactory.getLogger(MandatorImpl.class);
    private BundleContext bundleContext = null;
    private boolean dirty = false;
    private boolean initialized = false;
    private boolean started = false;
    private String factoryPid = null;
    private String servicePid = null;
    private ServiceReference<?> serviceRef = null;
    private String title = null;
    private String id = null;
    private String root = null;
    private String path = null;
    private Map<String, String> properties = new HashMap<String, String>();

    protected BundleContext getBundleContext() {
        return this.bundleContext;
    }

    protected void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        MandatorImpl.checkPermission("update");
        this.title = title;
        this.dirty = true;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        MandatorImpl.checkPermission("update");
        this.id = id;
        this.dirty = true;
    }

    @Override
    public String getRoot() {
        return this.root;
    }

    @Override
    public void setRoot(String root) {
        MandatorImpl.checkPermission("update");
        this.root = root;
        this.dirty = true;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        MandatorImpl.checkPermission("update");
        this.path = path;
        this.dirty = true;
    }

    @Override
    public String[] getPropertyKeys() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    @Override
    public String getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setInitialized(boolean initialized) {
        MandatorImpl.checkPermission("admin");
        this.initialized = initialized;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void setStarted(boolean started) {
        this.started = started;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public String getFactoryPid() {
        return this.factoryPid;
    }

    @Override
    public void setFactoryPid(String factoryPid) {
        MandatorImpl.checkPermission("admin");
        this.factoryPid = factoryPid;
    }

    @Override
    public String getServicePid() {
        return this.servicePid;
    }

    @Override
    public void setServicePid(String servicePid) {
        MandatorImpl.checkPermission("admin");
        this.servicePid = servicePid;
    }

    @Override
    public ServiceReference<?> getServiceRef() {
        return this.serviceRef;
    }

    @Override
    public void setServiceRef(ServiceReference<?> serviceRef) {
        MandatorImpl.checkPermission("admin");
        this.serviceRef = serviceRef;
    }

    @Override
    public void save(Dictionary<String, Object> config) {
        MandatorImpl.checkPermission("update");
        if (this.title != null) {
            config.put("mandator.title", this.title);
        }
        if (this.id != null) {
            config.put("mandator.id", this.id);
        }
        if (this.root != null) {
            config.put("mandator.root", this.root);
        }
        if (this.path != null) {
            config.put("mandator.path", this.path);
        }
        if (this.servicePid != null) {
            config.put("mandator.service-pid", this.servicePid);
        }
        if (this.factoryPid != null) {
            config.put("mandator.factory-pid", this.factoryPid);
        }
        config.put("mandator.init", this.initialized ? "true" : "false");
        config.put("mandator.start", this.started ? "true" : "false");
        this.dirty = false;
    }

    public void updated(Dictionary<String, ?> config) throws ConfigurationException {
        MandatorImpl.checkPermission("update");
        if (config == null) {
            return;
        }
        String tmp = null;
        tmp = (String)config.get("service.pid");
        if (tmp != null) {
            this.servicePid = tmp;
        }
        if ((tmp = (String)config.get("service.factorypid")) != null) {
            this.factoryPid = tmp;
        }
        if ((tmp = (String)config.get("mandator.title")) != null) {
            this.title = tmp;
        }
        if ((tmp = (String)config.get("mandator.id")) != null) {
            this.id = tmp;
        }
        if ((tmp = (String)config.get("mandator.root")) != null) {
            this.root = tmp;
        }
        if ((tmp = (String)config.get("mandator.path")) != null) {
            this.path = tmp;
        }
        this.initialized = (tmp = (String)config.get("mandator.init")) != null ? Boolean.parseBoolean(tmp) : false;
        tmp = (String)config.get("mandator.start");
        this.started = tmp != null ? Boolean.parseBoolean(tmp) : false;
        this.dirty = false;
        this.logger.debug("Update id={} root={} title={} path={} init={} start={}", new Object[]{this.id, this.root, this.title, this.path, new Boolean(this.initialized), new Boolean(this.started)});
    }

    private static void checkPermission(String action) {
    }
}

