/*
 * Decompiled with CFR 0.152.
 */
package org.i3xx.step.zero.service.impl.mandator;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.i3xx.step.zero.service.impl.mandator.MandatorImpl;
import org.i3xx.step.zero.service.model.cx.ContextProvider;
import org.i3xx.step.zero.service.model.mandator.Mandator;
import org.i3xx.step.zero.service.model.mandator.MandatorService;
import org.i3xx.step.zero.service.model.mandator.PropertyService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.cm.ManagedServiceFactory;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MandatorServiceImpl
implements ManagedServiceFactory,
MandatorService {
    public static final String mandatorConfigName = "i3xx.step.zero.MandatorService";
    private Logger logger = LoggerFactory.getLogger(MandatorServiceImpl.class);
    private BundleContext bundleContext = null;
    private Map<String, List<ServiceRegistration<?>>> regList = new HashMap();

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void deleted(String pid) {
        Mandator mand = this.getMandatorByPid(pid);
        if (mand != null) {
            mand.setInitialized(false);
            ServiceReference<?> ref = mand.getServiceRef();
            if (ref != null) {
                this.bundleContext.ungetService(ref);
            }
            List<ServiceRegistration<?>> list = this.regList.get(mand.getId());
            for (ServiceRegistration<?> r : list) {
                r.unregister();
            }
            list.clear();
        }
    }

    public String getName() {
        return mandatorConfigName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(String pid, Dictionary<String, ?> config) throws ConfigurationException {
        Mandator mand = this.getMandatorByPid(pid);
        if (mand == null) {
            mand = new MandatorImpl();
            ((MandatorImpl)mand).setBundleContext(this.bundleContext);
            ((ManagedService)mand).updated(config);
            if (!mand.isStarted()) {
                this.logger.info("The mandator '{}' has been skipped.", (Object)mand.getId());
                return;
            }
            if (!this.regList.containsKey(mand.getId())) {
                this.regList.put(mand.getId(), new ArrayList());
            }
            ServiceRegistration reg = null;
            String[] clazzes = new String[]{ManagedService.class.getName(), Mandator.class.getName()};
            Hashtable<String, String> properties = new Hashtable<String, String>();
            ((Dictionary)properties).put("service.pid", pid);
            ((Dictionary)properties).put("mandatorId", mand.getId());
            reg = this.bundleContext.registerService(clazzes, (Object)mand, properties);
            this.regList.get(mand.getId()).add(reg);
            ServiceReference ref = reg.getReference();
            if (ref != null) {
                mand.setServiceRef(ref);
            }
            Filter filter = null;
            try {
                filter = this.bundleContext.createFilter("(&(objectClass=" + PropertyService.class.getName() + ")(" + "mandatorId" + "=" + mand.getId() + "))");
            }
            catch (InvalidSyntaxException e) {
                this.logger.error("The syntax of the filter is not valid.", (Throwable)e);
            }
            ServiceTracker listenerTracker = new ServiceTracker(this.bundleContext, filter, null);
            listenerTracker.open();
            try {
                Object[] services = listenerTracker.getServices();
                if (services != null) {
                    for (Object service : services) {
                        String[] names;
                        PropertyService propertyService = (PropertyService)service;
                        for (String name : names = propertyService.getPropertyNames()) {
                            if (!propertyService.hasProperty(name)) continue;
                            mand.setProperty(name, propertyService.getProperty(name));
                        }
                    }
                }
            }
            finally {
                listenerTracker.close();
            }
            this.logger.info("The mandator '{}' has been started.", (Object)mand.getId());
        } else {
            ((ManagedService)mand).updated(config);
        }
    }

    public void stop(String id) {
        ServiceReference<?> ref;
        Mandator mand = this.getMandator(id);
        if (mand != null) {
            this.logger.info("Remove the mandator '{}'.", (Object)id);
            ref = mand.getServiceRef();
            if (ref != null) {
                this.bundleContext.ungetService(ref);
            }
            List<ServiceRegistration<?>> list = this.regList.get(mand.getId());
            for (ServiceRegistration<?> r : list) {
                r.unregister();
            }
            list.clear();
        }
        if ((ref = this.bundleContext.getServiceReference(ContextProvider.class)) != null) {
            this.logger.info("Remove all contexts of mandator '{}'.", (Object)id);
            ContextProvider provider = (ContextProvider)this.bundleContext.getService(ref);
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("mandatorId", id);
            provider.kill(properties);
        }
    }

    @Override
    public boolean save(String id, Dictionary<String, Object> config) {
        boolean f = false;
        Mandator m = this.getMandator(id);
        if (m != null && m.isDirty()) {
            m.save(config);
            f = true;
        }
        return f;
    }

    @Override
    public String[] getMandatorList() {
        ServiceReference[] refs;
        HashSet<String> list = new HashSet<String>();
        try {
            refs = this.bundleContext.getServiceReferences(Mandator.class.getName(), null);
            if (refs == null) {
                refs = new ServiceReference[]{};
            }
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
        for (ServiceReference ref : refs) {
            String mandatorId = (String)ref.getProperty("mandatorId");
            if (mandatorId == null) continue;
            list.add(mandatorId);
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public Mandator getMandator(String id) {
        Mandator mandator = null;
        ServiceReference[] ref = null;
        try {
            ref = this.bundleContext.getServiceReferences(Mandator.class.getName(), "(mandatorId=" + id + ")");
        }
        catch (InvalidSyntaxException e) {
            this.logger.warn("The filter syntax is not valid.", (Throwable)e);
        }
        if (ref != null && ref.length > 0) {
            mandator = (Mandator)this.bundleContext.getService(ref[0]);
        }
        return mandator;
    }

    protected Mandator getMandatorByPid(String pid) {
        Mandator mandator = null;
        ServiceReference[] ref = null;
        try {
            ref = this.bundleContext.getServiceReferences(Mandator.class.getName(), "(service.pid=" + pid + ")");
        }
        catch (InvalidSyntaxException e) {
            this.logger.warn("The filter syntax is not valid.", (Throwable)e);
        }
        if (ref != null && ref.length > 0) {
            mandator = (Mandator)this.bundleContext.getService(ref[0]);
        }
        return mandator;
    }

    public static Mandator getMandator(BundleContext context, String id) {
        Mandator mandator = null;
        ServiceReference[] ref = null;
        try {
            ref = context.getServiceReferences(Mandator.class.getName(), "(mandatorId=" + id + ")");
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException(e);
        }
        if (ref != null && ref.length > 0) {
            mandator = (Mandator)context.getService(ref[0]);
        }
        return mandator;
    }
}

