/*
 * Decompiled with CFR 0.152.
 */
package org.i3xx.step.zero.service.impl.mandator;

import java.util.NoSuchElementException;
import org.i3xx.step.zero.service.model.mandator.Mandator;
import org.i3xx.step.zero.service.model.mandator.MandatorService;
import org.i3xx.step.zero.service.model.mandator.PropertyService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyServiceTrackerImpl
extends ServiceTracker<PropertyService, PropertyService> {
    static Logger logger = LoggerFactory.getLogger(PropertyServiceTrackerImpl.class);

    public PropertyServiceTrackerImpl(BundleContext bundleContext) {
        super(bundleContext, PropertyService.class.getName(), null);
    }

    public PropertyService addingService(ServiceReference<PropertyService> reference) {
        PropertyService service = (PropertyService)this.context.getService(reference);
        String mandatorId = (String)reference.getProperty("mandatorId");
        if (mandatorId == null) {
            throw new IllegalArgumentException("The property mandatorId is missing.");
        }
        ServiceReference msr = this.context.getServiceReference(MandatorService.class);
        MandatorService ms = (MandatorService)this.context.getService(msr);
        Mandator mandator = ms.getMandator(mandatorId);
        if (mandator == null) {
            throw new NoSuchElementException("The mandator '" + mandatorId + "' is not available.");
        }
        for (String name : service.getPropertyNames()) {
            String value = service.getProperty(name);
            mandator.setProperty(name, value);
        }
        return service;
    }

    public void removedService(ServiceReference<PropertyService> reference, PropertyService service) {
        this.context.ungetService(reference);
    }
}

