/*
 * Decompiled with CFR 0.152.
 */
package org.i3xx.step.zero.service.impl.mandator;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Dictionary;
import java.util.Hashtable;
import org.i3xx.step.zero.service.impl.mandator.MandatorImpl;
import org.i3xx.step.zero.service.impl.mandator.MandatorServiceImpl;
import org.i3xx.step.zero.service.model.mandator.Mandator;
import org.i3xx.step.zero.service.model.mandator.MandatorService;
import org.i3xx.step.zero.service.model.mandator.RootService;
import org.i3xx.util.basic.io.FilePath;
import org.i3xx.util.basic.platform.Platform;
import org.i3xx.util.general.setup.impl.Setup;
import org.i3xx.util.general.setup.model.SetupService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RootServiceImpl
implements RootService {
    private Logger logger = LoggerFactory.getLogger(RootServiceImpl.class);
    private BundleContext bundleContext = null;

    public void startUp() {
        this.logger.info("Root service start up.");
    }

    public void createMandator(String mandatorId) throws IOException, InvalidSyntaxException, ConfigurationException {
        ServiceReference srA = this.bundleContext.getServiceReference(SetupService.class);
        SetupService setupService = (SetupService)this.bundleContext.getService(srA);
        ServiceReference srB = this.bundleContext.getServiceReference(MandatorService.class);
        MandatorService mandatorService = (MandatorService)this.bundleContext.getService(srB);
        ServiceReference srC = this.bundleContext.getServiceReference(ConfigurationAdmin.class);
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.bundleContext.getService(srC);
        ServiceReference srD = this.bundleContext.getServiceReference(Platform.class);
        Platform platformService = (Platform)this.bundleContext.getService(srD);
        Configuration config = configAdmin.createFactoryConfiguration("i3xx.step.zero.MandatorService");
        String pid = config.getPid();
        Hashtable<String, String> props = config.getProperties();
        if (props == null) {
            props = new Hashtable<String, String>();
            ((Dictionary)props).put("service.pid", pid);
            ((Dictionary)props).put("mandator.id", mandatorId);
            ((Dictionary)props).put("mandator.start", "true");
            config.update(props);
        }
        ((MandatorServiceImpl)mandatorService).updated(pid, props);
        Mandator m = mandatorService.getMandator(mandatorId);
        if (!m.isInitialized()) {
            Setup setup = setupService.getGeneralSetup();
            this.logger.info("Setup defaults title='{}' id='{}' root='{}'.", new Object[]{setup.getTitle(), setup.getId(), setup.getRoot()});
            String _root = Setup.setCurrentId((String)setup.getRoot(), (String)mandatorId);
            String _id = Setup.setCurrentId((String)setup.getId(), (String)mandatorId);
            String _title = Setup.setCurrentId((String)setup.getTitle(), (String)mandatorId);
            String path = _root.replace('/', File.separatorChar);
            if (path.startsWith(".")) {
                String home = (String)platformService.getObject("server.home");
                path = home + File.separator + path.substring(1);
            }
            this.logger.info("Create mandator root {}.", (Object)path);
            File root = this.createRootDirectory(path);
            String _path = root.getAbsolutePath();
            m.setId(_id);
            m.setRoot(_root);
            m.setPath(_path);
            m.setTitle(_title);
            m.setInitialized(true);
            Configuration configuration = configAdmin.getConfiguration(m.getServicePid());
            Dictionary dict = configuration.getProperties();
            m.save(dict);
            configuration.update(dict);
            this.logger.info("Setup a new mandator title='{}' id='{}' path='{}'.", new Object[]{_title, _id, _path});
        }
    }

    public void startMandator(String mandatorId) throws IOException, InvalidSyntaxException, ConfigurationException {
        ServiceReference cref = this.bundleContext.getServiceReference(ConfigurationAdmin.class);
        ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)this.bundleContext.getService(cref);
        Configuration configuration = null;
        Configuration[] c = configurationAdmin.listConfigurations("(&(service.factoryPid=i3xx.step.zero.MandatorService)(mandator.id=" + mandatorId + "))");
        Configuration configuration2 = configuration = c.length == 0 ? null : c[0];
        if (configuration == null) {
            System.out.println("ERROR: The mandator '" + mandatorId + "' is not available.");
        }
        String servicePid = configuration.getPid();
        ServiceReference mref = this.bundleContext.getServiceReference(MandatorService.class);
        MandatorService msrv = (MandatorService)this.bundleContext.getService(mref);
        Mandator mandator = msrv.getMandator(mandatorId);
        if (mandator == null) {
            this.logger.info("The mandator '{}' is not available on this system.", (Object)mandatorId);
            if (configuration != null) {
                Dictionary props = configuration.getProperties();
                props.put("mandator.start", "true");
                configuration.update(props);
                ((ManagedServiceFactory)msrv).updated(servicePid, props);
            }
        }
    }

    public void stopMandator(String mandatorId) throws IOException, InvalidSyntaxException, ConfigurationException {
        ServiceReference mref = this.bundleContext.getServiceReference(MandatorService.class);
        MandatorService msrv = (MandatorService)this.bundleContext.getService(mref);
        Mandator mandator = msrv.getMandator(mandatorId);
        if (mandator == null) {
            this.logger.info("The mandator '{}' is not available on this system.", (Object)mandatorId);
        }
        mandator.setStarted(false);
        this.save(mandator);
        ((MandatorServiceImpl)msrv).stop(mandator.getId());
    }

    public void destroyMandator(String servicePid) throws IOException, InvalidSyntaxException, ConfigurationException {
        ServiceReference cref = this.bundleContext.getServiceReference(ConfigurationAdmin.class);
        ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)this.bundleContext.getService(cref);
        Configuration configuration = configurationAdmin.getConfiguration(servicePid);
        if (configuration == null) {
            this.logger.info("The mandator '{}' is not available on this system (no config).", (Object)servicePid);
            return;
        }
        Dictionary dict = configuration.getProperties();
        if (dict.get("mandator.id") == null) {
            this.logger.info("The mandator '{}' is not available on this system (no mandator.id).", (Object)servicePid);
            return;
        }
        ServiceReference srA = this.bundleContext.getServiceReference(SetupService.class);
        SetupService setupService = (SetupService)this.bundleContext.getService(srA);
        ServiceReference srB = this.bundleContext.getServiceReference(MandatorService.class);
        MandatorService mandatorService = (MandatorService)this.bundleContext.getService(srB);
        ServiceReference srD = this.bundleContext.getServiceReference(Platform.class);
        Platform platformService = (Platform)this.bundleContext.getService(srD);
        String mandatorId = (String)dict.get("mandator.id");
        Mandator mandator = mandatorService.getMandator(mandatorId);
        if (mandator == null && dict != null) {
            mandator = new MandatorImpl();
            ((MandatorImpl)mandator).updated(dict);
        }
        String path = mandator.getPath();
        configuration.delete();
        if (path != null) {
            Setup setup = setupService.getGeneralSetup();
            String root = Setup.setCurrentId((String)setup.getRoot(), (String)mandatorId);
            FilePath fp = null;
            if (root.startsWith(".")) {
                String home = (String)platformService.getObject("server.home");
                fp = FilePath.append((String[])new String[]{home, root.substring(1)});
            } else {
                fp = FilePath.get((String)root);
            }
            FilePath mp = FilePath.get((String)path);
            if (mp.toString().contains(fp.toString())) {
                this.cleanDir(mp.toFile());
            } else {
                this.logger.warn("The path '{}' doesn't match the path '{}'.", (Object)fp.toString(), (Object)mp.toString());
            }
        } else {
            this.logger.warn("The mandator '{}' was not configured (nothing cleared).", (Object)mandatorId);
        }
    }

    private void save(Mandator mandator) throws IOException, InvalidSyntaxException {
        ServiceReference cref = this.bundleContext.getServiceReference(ConfigurationAdmin.class);
        ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)this.bundleContext.getService(cref);
        Configuration configuration = null;
        Configuration[] c = configurationAdmin.listConfigurations("(&(service.factoryPid=i3xx.step.zero.MandatorService)(mandator.id=" + mandator.getId() + "))");
        Configuration configuration2 = configuration = c.length == 0 ? null : c[0];
        if (configuration == null) {
            System.out.println("ERROR: The mandator '" + mandator.getId() + "' is not available.");
        }
        if (configuration != null) {
            Dictionary config = configuration.getProperties();
            mandator.save(config);
            configuration.update(config);
        }
    }

    public void listMandator() {
        ServiceReference mref = this.bundleContext.getServiceReference(MandatorService.class);
        MandatorService msrv = (MandatorService)this.bundleContext.getService(mref);
        for (String mandatorId : msrv.getMandatorList()) {
            Mandator mandator = msrv.getMandator(mandatorId);
            StringBuffer buffer = new StringBuffer();
            buffer.append("factory-pid: ");
            buffer.append(mandator.getFactoryPid());
            buffer.append(", service-pid: ");
            buffer.append(mandator.getServicePid());
            buffer.append(", id: ");
            buffer.append(mandator.getId());
            buffer.append(", title: ");
            buffer.append(mandator.getTitle());
            buffer.append(", path: ");
            buffer.append(mandator.getPath());
            buffer.append(", root: ");
            buffer.append(mandator.getRoot());
            for (String key : mandator.getPropertyKeys()) {
                buffer.append(", ");
                buffer.append(key);
                buffer.append(":");
                buffer.append(mandator.getProperty(key));
            }
            this.logger.info("The mandator '{}' has been started.", (Object)mandatorId);
            this.logger.debug(buffer.toString());
        }
    }

    public void listConfiguration() throws IOException, InvalidSyntaxException {
        ServiceReference srC = this.bundleContext.getServiceReference(ConfigurationAdmin.class);
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.bundleContext.getService(srC);
        Configuration[] c = configAdmin.listConfigurations("(service.factoryPid=i3xx.step.zero.MandatorService)");
        if (c == null || c.length == 0) {
            System.out.println("ERROR: There is no mandator available (configure one).");
        } else {
            for (int i = 0; i < c.length; ++i) {
                String servicePid = c[i].getPid();
                Dictionary props = c[i].getProperties();
                String id = props == null ? "undefined" : props.get("mandator.id");
                this.logger.info("Mandator id:{} pid:{}", (Object)id, (Object)servicePid);
            }
        }
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    private File createRootDirectory(String path) throws IOException {
        File root = new File(path);
        if (!root.exists()) {
            root.mkdirs();
        }
        File etc = new File(root, "etc");
        etc.mkdir();
        File dep = new File(root, "deploy");
        dep.mkdir();
        File tmp = new File(root, "temp");
        tmp.mkdir();
        File dat = new File(root, "data");
        dat.mkdir();
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanDir(File file) {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                this.cleanDir(f);
            }
        }
        file.delete();
        if (file.exists()) {
            try {
                RandomAccessFile raf = new RandomAccessFile(file, "rws");
                try {
                    raf.setLength(0L);
                }
                finally {
                    raf.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            file.deleteOnExit();
        }
    }
}

