/*
 * Decompiled with CFR 0.152.
 */
package org.ibeans.impl;

import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.activation.DataSource;
import org.ibeans.annotation.Invoke;
import org.ibeans.annotation.Namespace;
import org.ibeans.annotation.State;
import org.ibeans.annotation.filter.ErrorFilter;
import org.ibeans.annotation.param.Attachment;
import org.ibeans.annotation.param.Body;
import org.ibeans.annotation.param.BodyParam;
import org.ibeans.annotation.param.HeaderParam;
import org.ibeans.annotation.param.Optional;
import org.ibeans.annotation.param.Order;
import org.ibeans.annotation.param.PropertyParam;
import org.ibeans.annotation.param.ReturnType;
import org.ibeans.annotation.param.UriParam;
import org.ibeans.api.DataType;
import org.ibeans.api.IBeanStateData;
import org.ibeans.api.IBeansException;
import org.ibeans.api.InvocationContext;
import org.ibeans.api.ParamFactory;
import org.ibeans.api.ParamFactoryHolder;
import org.ibeans.impl.InternalInvocationContext;
import org.ibeans.impl.i18n.IBeansMessages;
import org.ibeans.impl.support.NamespaceMap;
import org.ibeans.impl.support.annotation.AnnotationMetaData;
import org.ibeans.impl.support.annotation.AnnotationUtils;
import org.ibeans.impl.support.datatype.DataTypeFactory;
import org.ibeans.impl.support.ds.DataSourceFactory;
import org.ibeans.impl.support.util.Utils;
import org.ibeans.spi.ErrorFilterFactory;
import org.ibeans.spi.ExpressionParser;
import org.ibeans.spi.IBeansPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IBeanReader {
    protected Map registryMap;
    protected ExpressionParser parser;
    protected IBeansPlugin plugin;

    public IBeanReader(IBeansPlugin plugin) throws IBeansException {
        this.plugin = plugin;
        this.registryMap = plugin.getProperties();
        this.parser = plugin.getExpressionParser();
    }

    private Object parsePropertyPlaceholderValues(Object value) {
        if (value != null && value instanceof String) {
            return this.parser.parsePropertyPlaceholders(this.registryMap, (String)value);
        }
        return value;
    }

    public IBeanStateData readStateData(Class ibean) throws IBeansException {
        DefaultIBeanStateData stateDataDefault = new DefaultIBeanStateData();
        this.addErrorFilters(ibean, stateDataDefault.getErrorFilters());
        this.addMethodLevelErrorFilters(ibean, stateDataDefault.getMethodLevelErrorFilters());
        try {
            Set<AnnotationMetaData> annos = AnnotationUtils.getFieldAnnotationsForHeirarchy(ibean);
            for (AnnotationMetaData metaData : annos) {
                ReturnType returnTypeAnno;
                PropertyParam propertyParam;
                Attachment attachment;
                HeaderParam headerParam;
                BodyParam bodyParam;
                if (metaData.getAnnotation() instanceof Order) continue;
                if (metaData.getAnnotation() instanceof Namespace) {
                    String prefix = ((Namespace)metaData.getAnnotation()).value();
                    stateDataDefault.getNamespaces().put(prefix, (String)((Field)metaData.getMember()).get(ibean));
                    continue;
                }
                Field field = (Field)metaData.getMember();
                UriParam uriParam = field.getAnnotation(UriParam.class);
                if (uriParam != null) {
                    String key;
                    String string = key = uriParam.value().length() > 0 ? uriParam.value() : field.getName();
                    if (ParamFactory.class.isAssignableFrom(field.getType())) {
                        ParamFactory pf = (ParamFactory)field.get(ibean);
                        Order order = field.getAnnotation(Order.class);
                        ParamFactoryHolder holder = order == null ? new ParamFactoryHolder(pf, key) : new ParamFactoryHolder(pf, key, order.value());
                        stateDataDefault.getUriFactoryParams().add(holder);
                    } else {
                        stateDataDefault.getUriParams().put(key, this.encode(field.get(ibean)));
                    }
                }
                if ((bodyParam = field.getAnnotation(BodyParam.class)) != null) {
                    String key;
                    String string = key = bodyParam.value().length() > 0 ? bodyParam.value() : field.getName();
                    if (ParamFactory.class.isAssignableFrom(field.getType())) {
                        ParamFactory pf = (ParamFactory)field.get(ibean);
                        Order order = field.getAnnotation(Order.class);
                        ParamFactoryHolder holder = order == null ? new ParamFactoryHolder(pf, key) : new ParamFactoryHolder(pf, key, order.value());
                        stateDataDefault.getPayloadFactoryParams().add(holder);
                    } else {
                        stateDataDefault.getPayloadParams().put(key, this.encode(field.get(ibean)));
                    }
                }
                if ((headerParam = field.getAnnotation(HeaderParam.class)) != null) {
                    String key;
                    String string = key = headerParam.value().length() > 0 ? headerParam.value() : field.getName();
                    if (ParamFactory.class.isAssignableFrom(field.getType())) {
                        ParamFactory pf = (ParamFactory)field.get(ibean);
                        Order order = field.getAnnotation(Order.class);
                        ParamFactoryHolder holder = order == null ? new ParamFactoryHolder(pf, key) : new ParamFactoryHolder(pf, key, order.value());
                        stateDataDefault.getHeaderFactoryParams().add(holder);
                    } else {
                        stateDataDefault.getHeaderParams().put(key, this.encode(field.get(ibean)));
                    }
                }
                if ((attachment = field.getAnnotation(Attachment.class)) != null) {
                    String key;
                    String string = key = attachment.value().length() > 0 ? attachment.value() : field.getName();
                    if (ParamFactory.class.isAssignableFrom(field.getType())) {
                        ParamFactory pf = (ParamFactory)field.get(ibean);
                        Order order = field.getAnnotation(Order.class);
                        ParamFactoryHolder holder = order == null ? new ParamFactoryHolder(pf, key) : new ParamFactoryHolder(pf, key, order.value());
                        stateDataDefault.getAttachmentFactoryParams().add(holder);
                    } else {
                        stateDataDefault.getAttachmentParams().put(key, this.encode(field.get(ibean)));
                    }
                }
                if ((propertyParam = field.getAnnotation(PropertyParam.class)) != null) {
                    String key;
                    String string = key = propertyParam.value().length() > 0 ? propertyParam.value() : field.getName();
                    if (ParamFactory.class.isAssignableFrom(field.getType())) {
                        ParamFactory pf = (ParamFactory)field.get(ibean);
                        Order order = field.getAnnotation(Order.class);
                        ParamFactoryHolder holder = order == null ? new ParamFactoryHolder(pf, key) : new ParamFactoryHolder(pf, key, order.value());
                        stateDataDefault.getPropertyFactoryParams().add(holder);
                    } else if (Map.class.isAssignableFrom(field.getType())) {
                        stateDataDefault.getPropertyParams().putAll((Map)field.get(ibean));
                    } else {
                        stateDataDefault.getPropertyParams().put(key, field.get(ibean));
                    }
                }
                if ((returnTypeAnno = field.getAnnotation(ReturnType.class)) == null) continue;
                if (field.getType().equals(Class.class)) {
                    stateDataDefault.setReturnType(DataTypeFactory.create((Class)field.get(ibean)));
                    continue;
                }
                throw new IllegalArgumentException("The @ReturnType annotation can only be set on Fields and parameters of type java.lang.Class");
            }
        }
        catch (Exception e) {
            throw new IBeansException(e);
        }
        return stateDataDefault;
    }

    protected void addErrorFilters(Class ibean, Map<String, org.ibeans.spi.ErrorFilter> filters) throws IBeansException {
        List<ErrorFilterFactory> factories = this.plugin.getErrorFilterFactories();
        List<AnnotationMetaData> annos = AnnotationUtils.getClassAnnotationInHeirarchy(ibean);
        block0: for (AnnotationMetaData metaData : annos) {
            Annotation anno = metaData.getAnnotation();
            if (!anno.annotationType().isAnnotationPresent(ErrorFilter.class)) continue;
            for (ErrorFilterFactory factory : factories) {
                if (!factory.isSupported(anno)) continue;
                ErrorFilterFactory.ErrorFilterHolder holder = factory.parse(anno);
                filters.put(holder.getMimeType().toString(), holder.getFilter());
                continue block0;
            }
        }
    }

    protected void addMethodLevelErrorFilters(Class ibean, Map<Method, org.ibeans.spi.ErrorFilter> filters) throws IBeansException {
        List<AnnotationMetaData> methodLevelFilterAnnotations = AnnotationUtils.getMethodMetaAnnotations(ibean, ErrorFilter.class);
        List<ErrorFilterFactory> factories = this.plugin.getErrorFilterFactories();
        block0: for (AnnotationMetaData metaData : methodLevelFilterAnnotations) {
            for (ErrorFilterFactory factory : factories) {
                if (!factory.isSupported(metaData.getAnnotation())) continue;
                ErrorFilterFactory.ErrorFilterHolder holder = factory.parse(metaData.getAnnotation());
                filters.put((Method)metaData.getMember(), holder.getFilter());
                continue block0;
            }
        }
    }

    public void populate(InvocationContext context) throws Exception {
        context.getIBeanConfig().getHeaderParams().putAll(context.getIBeanDefaultConfig().getHeaderParams());
        context.getIBeanConfig().getPayloadParams().putAll(context.getIBeanDefaultConfig().getPayloadParams());
        context.getIBeanConfig().getUriParams().putAll(context.getIBeanDefaultConfig().getUriParams());
        context.getIBeanConfig().getPropertyParams().putAll(context.getIBeanDefaultConfig().getPropertyParams());
        context.getIBeanConfig().getPayloadParams().putAll(context.getIBeanDefaultConfig().getPayloadParams());
        Method method = context.getMethod();
        Object[] args = context.getArgs();
        DataType returnType = DataTypeFactory.createFromReturnType(context.getMethod());
        this.checkReturnClass(returnType, method);
        boolean stateCall = false;
        if (method.getName().startsWith("ibean")) {
            return;
        }
        if (method.isAnnotationPresent(State.class)) {
            stateCall = true;
            context.getIBeanConfig().setHeaderParams(context.getIBeanDefaultConfig().getHeaderParams());
            context.getIBeanConfig().setPayloadParams(context.getIBeanDefaultConfig().getPayloadParams());
            context.getIBeanConfig().setUriParams(context.getIBeanDefaultConfig().getUriParams());
        }
        List<Object> payloads = context.getIBeanConfig().getPayloads();
        if (method.getParameterAnnotations().length > 0) {
            if (method.getParameterAnnotations()[0].length > 0) {
                for (int i = 0; i < method.getParameterAnnotations().length; ++i) {
                    Annotation annotation = method.getParameterAnnotations()[i][0];
                    boolean optional = false;
                    if (annotation.annotationType().equals(Optional.class)) {
                        optional = true;
                        annotation = method.getParameterAnnotations()[i][1];
                    }
                    if (annotation.annotationType().equals(UriParam.class)) {
                        if (args[i] instanceof ParamFactory) {
                            this.addComplexParam(annotation, args[i], optional, context);
                            continue;
                        }
                        if (args[i] instanceof Map) {
                            this.addUriParamMap((UriParam)annotation, (Map)args[i], context.getIBeanConfig().getUriParams());
                            continue;
                        }
                        this.addUriParam((UriParam)annotation, args[i], method, context.getIBeanConfig().getUriParams(), optional);
                        continue;
                    }
                    if (annotation.annotationType().equals(HeaderParam.class)) {
                        if (args[i] instanceof ParamFactory) {
                            this.addComplexParam(annotation, args[i], optional, context);
                            continue;
                        }
                        this.addHeaderParam((HeaderParam)annotation, args[i], method, context.getIBeanConfig().getHeaderParams(), optional);
                        continue;
                    }
                    if (annotation.annotationType().equals(PropertyParam.class)) {
                        if (args[i] instanceof ParamFactory) {
                            this.addComplexParam(annotation, args[i], optional, context);
                            continue;
                        }
                        if (stateCall) {
                            this.addPropertyParam((PropertyParam)annotation, args[i], method, context.getIBeanDefaultConfig().getPropertyParams(), optional);
                            continue;
                        }
                        if (args[i] instanceof ParamFactory) {
                            throw new IllegalArgumentException("The @PropertyParam can only be used on call methods without a ParamFactory return type");
                        }
                        this.addPropertyParam((PropertyParam)annotation, args[i], method, context.getIBeanConfig().getPropertyParams(), optional);
                        continue;
                    }
                    if (annotation.annotationType().equals(BodyParam.class)) {
                        this.addPayloadParam((BodyParam)annotation, args[i], method, context.getIBeanConfig().getPayloadParams(), optional);
                        continue;
                    }
                    if (annotation.annotationType().equals(Body.class)) {
                        payloads.add(args[i]);
                        continue;
                    }
                    if (annotation.annotationType().equals(ReturnType.class)) {
                        if (!args[i].getClass().equals(Class.class)) continue;
                        if (stateCall) {
                            ((DefaultIBeanStateData)context.getIBeanDefaultConfig()).setReturnType(DataTypeFactory.create((Class)args[i]));
                            continue;
                        }
                        context.setInvocationReturnType(DataTypeFactory.create((Class)args[i]));
                        continue;
                    }
                    if (annotation.annotationType().equals(Attachment.class)) {
                        this.addAttachments((Attachment)annotation, args[i], method, context.getIBeanConfig().getAttachments(), optional);
                        continue;
                    }
                    throw new IllegalArgumentException("unknown annotation: " + annotation);
                }
            } else {
                throw new IllegalArgumentException("Parameter for method: " + method.getName() + " has parameters that are not annotated");
            }
        }
        if (!stateCall) {
            if (this.mustDetermineHttpMethod(context)) {
                boolean post;
                boolean bl = post = context.getIBeanConfig().getPayloads().size() > 0 || context.getIBeanConfig().getPayloadParams().size() > 0;
                if (!post) {
                    context.getIBeanConfig().addPropertyParam("http.method", "GET");
                } else {
                    context.getIBeanConfig().addPropertyParam("http.method", "POST");
                }
            }
            ((InternalInvocationContext)context).createMessage();
        }
    }

    private boolean mustDetermineHttpMethod(InvocationContext context) throws URISyntaxException {
        boolean httpMethodNotSet = context.getIBeanConfig().getPropertyParams().get("http.method") == null;
        String parsedCallUri = context.getParsedCallUri();
        return httpMethodNotSet && parsedCallUri != null && parsedCallUri.startsWith("http");
    }

    private void checkReturnClass(DataType dataType, Method m) {
        Class<?> c = dataType.getType();
        if (c.isPrimitive() && !Void.TYPE.equals(c) && !m.getName().equals("equals") && !m.getName().equals("hashcode")) {
            throw new IllegalArgumentException("iBean methods can only return objects, not primitives." + "Method is: " + m + ". Class is: " + c);
        }
    }

    protected void addUriParamMap(UriParam annotation, Map<String, Object> arg, Map<String, Object> uriParams) throws UnsupportedEncodingException {
        String[] p = Utils.splitAndTrim(annotation.value(), ",");
        for (int j = 0; j < p.length; ++j) {
            String s = p[j];
            if (arg.containsKey(s)) {
                uriParams.put(s, this.encode(this.parsePropertyPlaceholderValues(arg.get(s))));
                continue;
            }
            uriParams.put(s, "null.param");
        }
        for (String key : arg.keySet()) {
            if (uriParams.containsKey(key)) continue;
            throw new IllegalArgumentException("A UriParam named '" + key + "' was included in a @UriParam as a Map but was not specified on the @UriParam annotation: " + annotation);
        }
    }

    protected void addAttachments(Attachment annotation, Object arg, Method method, Set<DataSource> attachments, boolean optional) {
        if (arg == null) {
            if (!optional) {
                throw new IllegalArgumentException(IBeansMessages.parameterNotOptional((Annotation)annotation, method));
            }
        } else if (arg.getClass().isArray()) {
            for (int i = 0; i < ((Object[])arg).length; ++i) {
                attachments.add(DataSourceFactory.create(annotation.value() + (i + 1), ((Object[])arg)[i]));
            }
        } else {
            attachments.add(DataSourceFactory.create(annotation.value(), arg));
        }
    }

    protected void addPropertyParam(PropertyParam annotation, Object arg, Method method, Map<String, Object> params, boolean optional) {
        this.addParams((Annotation)annotation, this.parsePropertyPlaceholderValues(arg), annotation.value(), method, params, optional);
    }

    protected void addUriParam(UriParam annotation, Object arg, Method method, Map<String, Object> params, boolean optional) throws UnsupportedEncodingException {
        if (arg == null && optional) {
            arg = "null.param";
        } else if (arg == null) {
            throw new IllegalArgumentException(IBeansMessages.parameterNotOptional((Annotation)annotation, method));
        }
        params.put(annotation.value(), this.encode(this.parsePropertyPlaceholderValues(arg)));
    }

    protected void addComplexParam(Annotation annotation, Object arg, boolean optional, InvocationContext ctx) throws Exception {
        String paramName;
        if (arg == null && optional) {
            arg = "null.param";
        } else if (arg == null) {
            throw new IllegalArgumentException(IBeansMessages.parameterNotOptional(annotation, ctx.getMethod()));
        }
        if (!(arg instanceof ParamFactory)) {
            throw new IllegalArgumentException("@ComplexHeaderParam must annotate an instance of ParamFactory");
        }
        if (annotation instanceof UriParam) {
            paramName = ((UriParam)annotation).value();
        } else if (annotation instanceof HeaderParam) {
            paramName = ((HeaderParam)annotation).value();
        } else if (annotation instanceof BodyParam) {
            paramName = ((BodyParam)annotation).value();
        } else if (annotation instanceof PropertyParam) {
            paramName = ((PropertyParam)annotation).value();
        } else {
            throw new IllegalArgumentException("ParamFactory not supported in conjunction with: " + annotation);
        }
        ParamFactory factory = (ParamFactory)arg;
        Object value = factory.create(paramName, optional, ctx);
        if (annotation instanceof UriParam) {
            ctx.getIBeanConfig().addUriParam(paramName, this.encode(value));
        } else if (annotation instanceof HeaderParam) {
            ctx.getIBeanConfig().addHeaderParam(paramName, this.encode(value));
        } else if (annotation instanceof PropertyParam) {
            ctx.getIBeanConfig().addPropertyParam(paramName, this.encode(value));
        } else {
            ctx.getIBeanConfig().addPayloadParam(paramName, this.encode(value));
        }
    }

    protected void addPayloadParam(BodyParam annotation, Object arg, Method method, Map<String, Object> params, boolean optional) {
        this.addParams((Annotation)annotation, this.parsePropertyPlaceholderValues(arg), annotation.value(), method, params, optional);
    }

    protected void addHeaderParam(HeaderParam annotation, Object arg, Method method, Map<String, Object> params, boolean optional) {
        this.addParams((Annotation)annotation, this.parsePropertyPlaceholderValues(arg), annotation.value(), method, params, optional);
    }

    protected void addParams(Annotation annotation, Object arg, String key, Method method, Map<String, Object> params, boolean optional) {
        if (arg == null) {
            if (!optional) {
                throw new IllegalArgumentException(IBeansMessages.parameterNotOptional(annotation, method).toString());
            }
            params.remove(key);
        } else if (arg instanceof Map) {
            if (method.getAnnotation(Invoke.class) != null) {
                params.put(key, arg);
            } else {
                params.putAll((Map)arg);
            }
        } else {
            params.put(key, arg);
        }
    }

    protected Object encode(Object obj) throws UnsupportedEncodingException {
        if (obj == null) {
            return obj;
        }
        if (obj instanceof String) {
            String result = obj.toString().replaceAll(" ", "+");
            result = result.replaceAll("@", "%40");
            result = result.replaceAll("#", "%23");
            return result;
        }
        return obj;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DefaultIBeanStateData
    implements IBeanStateData {
        protected Map<String, Object> defaultUriParams = new HashMap<String, Object>();
        protected Map<String, Object> defaultHeaderParams = new HashMap<String, Object>();
        protected Map<String, Object> defaultPayloadParams = new HashMap<String, Object>();
        protected Map<String, Object> defaultPropertyParams = new HashMap<String, Object>();
        protected Map<String, Object> defaultAttachmentParams = new HashMap<String, Object>();
        protected Set<ParamFactoryHolder> defaultUriFactoryParams = new TreeSet<ParamFactoryHolder>();
        protected Set<ParamFactoryHolder> defaultHeaderFactoryParams = new TreeSet<ParamFactoryHolder>();
        protected Set<ParamFactoryHolder> defaultPayloadFactoryParams = new TreeSet<ParamFactoryHolder>();
        protected Set<ParamFactoryHolder> defaultPropertyFactoryParams = new TreeSet<ParamFactoryHolder>();
        protected Set<ParamFactoryHolder> defaultAttachmentFactoryParams = new TreeSet<ParamFactoryHolder>();
        protected Map<String, org.ibeans.spi.ErrorFilter> errorFilters = new HashMap<String, org.ibeans.spi.ErrorFilter>();
        protected Map<Method, org.ibeans.spi.ErrorFilter> methodLevelErrorFilters = new HashMap<Method, org.ibeans.spi.ErrorFilter>();
        protected DataType returnType = null;
        protected NamespaceMap namespaces = new NamespaceMap();

        DefaultIBeanStateData() {
        }

        @Override
        public Map<String, Object> getHeaderParams() {
            return this.defaultHeaderParams;
        }

        @Override
        public Map<String, Object> getPayloadParams() {
            return this.defaultPayloadParams;
        }

        @Override
        public Map<String, Object> getUriParams() {
            return this.defaultUriParams;
        }

        @Override
        public Map<String, Object> getPropertyParams() {
            return this.defaultPropertyParams;
        }

        @Override
        public Map<String, Object> getAttachmentParams() {
            return this.defaultAttachmentParams;
        }

        @Override
        public DataType getReturnType() {
            return this.returnType;
        }

        @Override
        public Map<String, org.ibeans.spi.ErrorFilter> getErrorFilters() {
            return this.errorFilters;
        }

        @Override
        public Map<Method, org.ibeans.spi.ErrorFilter> getMethodLevelErrorFilters() {
            return this.methodLevelErrorFilters;
        }

        @Override
        public Set<ParamFactoryHolder> getUriFactoryParams() {
            return this.defaultUriFactoryParams;
        }

        @Override
        public Set<ParamFactoryHolder> getHeaderFactoryParams() {
            return this.defaultHeaderFactoryParams;
        }

        @Override
        public Set<ParamFactoryHolder> getPayloadFactoryParams() {
            return this.defaultPayloadFactoryParams;
        }

        @Override
        public Set<ParamFactoryHolder> getPropertyFactoryParams() {
            return this.defaultPropertyFactoryParams;
        }

        @Override
        public Set<ParamFactoryHolder> getAttachmentFactoryParams() {
            return this.defaultAttachmentFactoryParams;
        }

        @Override
        public NamespaceMap getNamespaces() {
            return this.namespaces;
        }

        public void setReturnType(DataType returnType) {
            IBeanReader.this.checkReturnClass(returnType, null);
            this.returnType = returnType;
        }
    }
}

