/*
 * Decompiled with CFR 0.152.
 */
package org.ibeans.impl.i18n;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Properties;

public class IBeansMessages {
    private static final IBeansMessages factory = new IBeansMessages();
    private static Properties bundle;

    protected IBeansMessages() {
        bundle = new Properties();
        try {
            bundle.load(this.getClass().getResourceAsStream("/META-INF/i18n/ibeans-messages.properties"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected String createMessage(int index, Object ... args) {
        String message = bundle.getProperty(String.valueOf(index));
        if (message == null) {
            throw new IllegalArgumentException("This is no message in bundle for id: " + index);
        }
        return String.format(message, args);
    }

    public static String versionNotSet() {
        return factory.createMessage(1, new Object[0]);
    }

    public static String serverStartedAt(long startDate) {
        return factory.createMessage(2, new Date(startDate));
    }

    public static String serverShutdownAt(Date date) {
        return factory.createMessage(3, date);
    }

    public static String modulesLoaded(String modules) {
        return factory.createMessage(4, modules);
    }

    public static String notSet() {
        return factory.createMessage(5, new Object[0]);
    }

    public static String parameterNotOptional(Annotation annotation, Method method) {
        return factory.createMessage(9, ((Object)annotation).toString(), method.toString());
    }

    public static String onlySingleEvalParamSupported(Method method) {
        return factory.createMessage(10, method.toString());
    }

    public static String failedToSendMessageUsingUri(String uri) {
        return factory.createMessage(11, uri);
    }
}

