/*
 * Decompiled with CFR 0.152.
 */
package org.ibeans.impl.support.datatype;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.ibeans.impl.support.datatype.MethodParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GenericTypeResolver {
    private static final Map<Class, Reference<Map<TypeVariable, Type>>> typeVariableCache = Collections.synchronizedMap(new WeakHashMap());

    private GenericTypeResolver() {
    }

    public static Type getTargetType(MethodParameter methodParam) {
        if (methodParam.getConstructor() != null) {
            return methodParam.getConstructor().getGenericParameterTypes()[methodParam.getParameterIndex()];
        }
        if (methodParam.getParameterIndex() >= 0) {
            return methodParam.getMethod().getGenericParameterTypes()[methodParam.getParameterIndex()];
        }
        return methodParam.getMethod().getGenericReturnType();
    }

    public static Class<?> resolveParameterType(MethodParameter methodParam, Class clazz) {
        Map<TypeVariable, Type> typeVariableMap;
        Type genericType = GenericTypeResolver.getTargetType(methodParam);
        Type rawType = GenericTypeResolver.getRawType(genericType, typeVariableMap = GenericTypeResolver.getTypeVariableMap(clazz));
        Class<?> result = rawType instanceof Class ? (Class<?>)rawType : methodParam.getParameterType();
        methodParam.setParameterType(result);
        methodParam.typeVariableMap = typeVariableMap;
        return result;
    }

    public static Class<?> resolveReturnType(Method method, Class clazz) {
        Map<TypeVariable, Type> typeVariableMap;
        Type genericType = method.getGenericReturnType();
        Type rawType = GenericTypeResolver.getRawType(genericType, typeVariableMap = GenericTypeResolver.getTypeVariableMap(clazz));
        return rawType instanceof Class ? (Class<?>)rawType : method.getReturnType();
    }

    public static Class<?> resolveTypeArgument(Class clazz, Class genericIfc) {
        Class[] typeArgs = GenericTypeResolver.resolveTypeArguments(clazz, genericIfc);
        if (typeArgs == null) {
            return null;
        }
        if (typeArgs.length != 1) {
            throw new IllegalArgumentException("Expected 1 type argument on generic interface [" + genericIfc.getName() + "] but found " + typeArgs.length);
        }
        return typeArgs[0];
    }

    public static Class[] resolveTypeArguments(Class clazz, Class genericIfc) {
        return GenericTypeResolver.doResolveTypeArguments(clazz, clazz, genericIfc);
    }

    private static Class[] doResolveTypeArguments(Class ownerClass, Class classToIntrospect, Class genericIfc) {
        while (classToIntrospect != null) {
            Type[] ifcs;
            for (Type ifc : ifcs = classToIntrospect.getGenericInterfaces()) {
                if (ifc instanceof ParameterizedType) {
                    ParameterizedType paramIfc = (ParameterizedType)ifc;
                    Type rawType = paramIfc.getRawType();
                    if (genericIfc.equals(rawType)) {
                        Type[] typeArgs = paramIfc.getActualTypeArguments();
                        Class[] result = new Class[typeArgs.length];
                        for (int i = 0; i < typeArgs.length; ++i) {
                            Type arg = typeArgs[i];
                            if (arg instanceof TypeVariable) {
                                arg = GenericTypeResolver.getTypeVariableMap(ownerClass).get((TypeVariable)arg);
                            }
                            result[i] = arg instanceof Class ? (Class)arg : Object.class;
                        }
                        return result;
                    }
                    if (!genericIfc.isAssignableFrom((Class)rawType)) continue;
                    return GenericTypeResolver.doResolveTypeArguments(ownerClass, (Class)rawType, genericIfc);
                }
                if (!genericIfc.isAssignableFrom((Class)ifc)) continue;
                return GenericTypeResolver.doResolveTypeArguments(ownerClass, (Class)ifc, genericIfc);
            }
            classToIntrospect = classToIntrospect.getSuperclass();
        }
        return null;
    }

    static Class resolveType(Type genericType, Map<TypeVariable, Type> typeVariableMap) {
        Type rawType = GenericTypeResolver.getRawType(genericType, typeVariableMap);
        return rawType instanceof Class ? (Class)rawType : Object.class;
    }

    static Type getRawType(Type genericType, Map<TypeVariable, Type> typeVariableMap) {
        TypeVariable tv;
        Type resolvedType = genericType;
        if (genericType instanceof TypeVariable && (resolvedType = typeVariableMap.get(tv = (TypeVariable)genericType)) == null) {
            resolvedType = GenericTypeResolver.extractBoundForTypeVariable(tv);
        }
        if (resolvedType instanceof ParameterizedType) {
            return ((ParameterizedType)resolvedType).getRawType();
        }
        return resolvedType;
    }

    static Map<TypeVariable, Type> getTypeVariableMap(Class clazz) {
        Map<TypeVariable, Type> typeVariableMap;
        Reference<Map<TypeVariable, Type>> ref = typeVariableCache.get(clazz);
        Map<TypeVariable, Type> map = typeVariableMap = ref != null ? ref.get() : null;
        if (typeVariableMap == null) {
            ParameterizedType pt;
            Class<?> type;
            typeVariableMap = new HashMap<TypeVariable, Type>();
            GenericTypeResolver.extractTypeVariablesFromGenericInterfaces(clazz.getGenericInterfaces(), typeVariableMap);
            Type genericType = clazz.getGenericSuperclass();
            for (type = clazz.getSuperclass(); type != null && !Object.class.equals((Object)type); type = type.getSuperclass()) {
                if (genericType instanceof ParameterizedType) {
                    pt = (ParameterizedType)genericType;
                    GenericTypeResolver.populateTypeMapFromParameterizedType(pt, typeVariableMap);
                }
                GenericTypeResolver.extractTypeVariablesFromGenericInterfaces(type.getGenericInterfaces(), typeVariableMap);
                genericType = type.getGenericSuperclass();
            }
            type = clazz;
            while (type.isMemberClass()) {
                genericType = type.getGenericSuperclass();
                if (genericType instanceof ParameterizedType) {
                    pt = (ParameterizedType)genericType;
                    GenericTypeResolver.populateTypeMapFromParameterizedType(pt, typeVariableMap);
                }
                type = type.getEnclosingClass();
            }
            typeVariableCache.put(clazz, new WeakReference<Map<TypeVariable, Type>>(typeVariableMap));
        }
        return typeVariableMap;
    }

    static Type extractBoundForTypeVariable(TypeVariable typeVariable) {
        Type[] bounds = typeVariable.getBounds();
        if (bounds.length == 0) {
            return Object.class;
        }
        Type bound = bounds[0];
        if (bound instanceof TypeVariable) {
            bound = GenericTypeResolver.extractBoundForTypeVariable((TypeVariable)bound);
        }
        return bound;
    }

    private static void extractTypeVariablesFromGenericInterfaces(Type[] genericInterfaces, Map<TypeVariable, Type> typeVariableMap) {
        for (Type genericInterface : genericInterfaces) {
            if (genericInterface instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericInterface;
                GenericTypeResolver.populateTypeMapFromParameterizedType(pt, typeVariableMap);
                if (!(pt.getRawType() instanceof Class)) continue;
                GenericTypeResolver.extractTypeVariablesFromGenericInterfaces(((Class)pt.getRawType()).getGenericInterfaces(), typeVariableMap);
                continue;
            }
            if (!(genericInterface instanceof Class)) continue;
            GenericTypeResolver.extractTypeVariablesFromGenericInterfaces(((Class)genericInterface).getGenericInterfaces(), typeVariableMap);
        }
    }

    private static void populateTypeMapFromParameterizedType(ParameterizedType type, Map<TypeVariable, Type> typeVariableMap) {
        if (type.getRawType() instanceof Class) {
            Type[] actualTypeArguments = type.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeVariables = ((Class)type.getRawType()).getTypeParameters();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                Type actualTypeArgument = actualTypeArguments[i];
                TypeVariable variable = typeVariables[i];
                if (actualTypeArgument instanceof Class) {
                    typeVariableMap.put(variable, actualTypeArgument);
                    continue;
                }
                if (actualTypeArgument instanceof GenericArrayType) {
                    typeVariableMap.put(variable, actualTypeArgument);
                    continue;
                }
                if (actualTypeArgument instanceof ParameterizedType) {
                    typeVariableMap.put(variable, actualTypeArgument);
                    continue;
                }
                if (!(actualTypeArgument instanceof TypeVariable)) continue;
                TypeVariable typeVariableArgument = (TypeVariable)actualTypeArgument;
                Type resolvedType = typeVariableMap.get(typeVariableArgument);
                if (resolvedType == null) {
                    resolvedType = GenericTypeResolver.extractBoundForTypeVariable(typeVariableArgument);
                }
                typeVariableMap.put(variable, resolvedType);
            }
        }
    }
}

