/*
   Copyright 2021 WeAreFrank!

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
package nl.nn.credentialprovider;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;

import nl.nn.credentialprovider.util.AppConstants;

/**
 * CredentialFactory that reads its credentials from a plain (unencrypted) .properties file.
 * For adequate privacy in production environments, the source file should not be readable by unauthorised users.
 * 
 * @author Gerrit van Brakel
 *
 */
public class PropertyFileCredentialFactory extends MapCredentialFactory {

	public final String PROPERTY_BASE="credentialFactory.map";

	public final String FILE_PROPERTY=PROPERTY_BASE+".properties";

	private final String propertiesFile = "credentials.properties";

	@Override
	public String getPropertyBase() {
		return PROPERTY_BASE;
	}

	@Override
	protected Map<String, String> getCredentialMap(AppConstants appConstants) throws MalformedURLException, IOException {
		try (InputStream propertyStream = getInputStream(appConstants, FILE_PROPERTY, propertiesFile, "Credentials")) {
			Properties properties = new Properties();
			properties.load(propertyStream);
			Map<String,String> map = new LinkedHashMap<>();
			properties.forEach((k,v) -> map.put((String)k, (String)v));
			return map;
		}
	}

}
