/*
   Copyright 2023 WeAreFrank!

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
package nl.nn.adapterframework.management.bus;

import org.springframework.http.MediaType;

import nl.nn.adapterframework.util.JacksonUtils;

public class JsonResponseMessage extends StringResponseMessage {

	public JsonResponseMessage(Object payload) {
		super(JacksonUtils.convertToJson(payload), MediaType.APPLICATION_JSON);
	}
}
