/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.management.bus;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import nl.nn.adapterframework.management.bus.LocalGateway;
import nl.nn.adapterframework.util.SpringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.integration.IntegrationPattern;
import org.springframework.integration.IntegrationPatternType;
import org.springframework.util.ClassUtils;

public class InboundGatewayFactory
implements InitializingBean,
ApplicationContextAware {
    private Logger log = LogManager.getLogger((Object)this);
    private ApplicationContext applicationContext;
    private static final String LOCAL_GATEWAY_CLASSNAME = LocalGateway.class.getCanonicalName();
    private String gatewayClassnames = LOCAL_GATEWAY_CLASSNAME;

    public void afterPropertiesSet() throws Exception {
        Set<String> gateways = this.getInboundGateways();
        if (gateways.isEmpty()) {
            this.log.info("did not find any inbound gateways to initialize");
            return;
        }
        Supplier[] supplierArray = new Supplier[1];
        supplierArray[0] = gateways::toString;
        this.log.info("found the following inbound gateways {}", supplierArray);
        for (String gateway : gateways) {
            try {
                IntegrationPattern ipGw = this.createGateway(gateway);
                ConfigurableBeanFactory beanFactory = (ConfigurableBeanFactory)this.applicationContext.getAutowireCapableBeanFactory();
                beanFactory.registerSingleton(gateway, (Object)ipGw);
                this.log.info("created inbound gateway [{}]", (Object)gateway);
            }
            catch (BeanInstantiationException | BeanCreationException | NoSuchBeanDefinitionException e) {
                this.log.warn("unable to create inbound gateway [{}]", (Object)gateway);
            }
        }
    }

    private Set<String> getInboundGateways() {
        if (StringUtils.isBlank((CharSequence)this.gatewayClassnames)) {
            return Collections.singleton(LOCAL_GATEWAY_CLASSNAME);
        }
        TreeSet<String> gateways = new TreeSet<String>(Arrays.asList(this.gatewayClassnames.split(",")));
        gateways.add(LOCAL_GATEWAY_CLASSNAME);
        return Collections.unmodifiableSet(gateways);
    }

    private IntegrationPattern createGateway(String gatewayClassname) {
        Class gatewayClass = ClassUtils.resolveClassName((String)gatewayClassname, (ClassLoader)this.applicationContext.getClassLoader());
        if (!IntegrationPattern.class.isAssignableFrom(gatewayClass)) {
            throw new IllegalArgumentException("gateway [" + gatewayClassname + "] does not implement type IntegrationPattern");
        }
        IntegrationPattern gateway = (IntegrationPattern)SpringUtils.createBean((ApplicationContext)this.applicationContext, (Class)gatewayClass);
        IntegrationPatternType type = gateway.getIntegrationPatternType();
        if (IntegrationPatternType.inbound_gateway == type) {
            return gateway;
        }
        this.applicationContext.getAutowireCapableBeanFactory().destroyBean((Object)gateway);
        throw new IllegalArgumentException("gateway [" + gatewayClassname + "] must be of an Inbound Gateway");
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setGatewayClassnames(String gatewayClassnames) {
        this.gatewayClassnames = gatewayClassnames;
    }
}

