/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.management.bus;

import nl.nn.adapterframework.management.bus.OutboundGateway;
import nl.nn.adapterframework.util.SpringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.integration.IntegrationPatternType;
import org.springframework.util.ClassUtils;

public class OutboundGatewayFactory<T>
implements InitializingBean,
ApplicationContextAware,
FactoryBean<OutboundGateway<T>> {
    private Logger log = LogManager.getLogger((Object)this);
    private ApplicationContext applicationContext;
    private OutboundGateway<T> gateway;
    private static final String GATEWAY_CLASS_KEY = "management.gateway.outbound.class";
    private String gatewayClassname = null;

    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isBlank((CharSequence)this.gatewayClassname)) {
            throw new IllegalStateException("no outbound gateway class specified. Please set [management.gateway.outbound.class]");
        }
        this.log.info("attempting to initialize using gateway class [{}]", (Object)this.gatewayClassname);
        Class gatewayClass = ClassUtils.resolveClassName((String)this.gatewayClassname, (ClassLoader)this.applicationContext.getClassLoader());
        if (!OutboundGateway.class.isAssignableFrom(gatewayClass)) {
            throw new IllegalArgumentException("gateway [" + this.gatewayClassname + "] does not implement type IntegrationGateway");
        }
        this.gateway = (OutboundGateway)SpringUtils.createBean((ApplicationContext)this.applicationContext, (Class)gatewayClass);
        IntegrationPatternType type = this.gateway.getIntegrationPatternType();
        if (IntegrationPatternType.outbound_gateway != type) {
            throw new IllegalArgumentException("gateway [" + this.gatewayClassname + "] must be of an Outbound Gateway");
        }
        this.log.info("created gateway [{}]", this.gateway);
    }

    public OutboundGateway<T> getObject() {
        return this.gateway;
    }

    public Class<? extends OutboundGateway> getObjectType() {
        return this.gateway != null ? this.gateway.getClass() : OutboundGateway.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setGatewayClassname(String gatewayClassname) {
        this.gatewayClassname = gatewayClassname;
    }
}

