/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.management.gateway;

import nl.nn.adapterframework.management.bus.BusException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.integration.handler.AbstractReplyProducingMessageHandler;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageDeliveryException;

public class ErrorMessageConverter
extends AbstractReplyProducingMessageHandler {
    private final Logger log = LogManager.getLogger(ErrorMessageConverter.class);

    public ErrorMessageConverter() {
        this.setRequiresReply(true);
    }

    protected Object handleRequestMessage(Message<?> requestMessage) {
        if (requestMessage.getPayload() instanceof Exception) {
            Exception e = (Exception)requestMessage.getPayload();
            this.log.error("an error occurred while handling frank-management-bus request", (Throwable)e);
            if (e instanceof MessageDeliveryException) {
                return new ResponseEntity(HttpStatus.INTERNAL_SERVER_ERROR);
            }
            if (e.getCause() instanceof BusException) {
                return new ResponseEntity((Object)e.getCause().getMessage(), HttpStatus.BAD_REQUEST);
            }
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity(HttpStatus.BAD_REQUEST);
    }
}

