/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.management.gateway;

import nl.nn.adapterframework.management.bus.OutboundGateway;
import nl.nn.adapterframework.management.gateway.HttpOutboundHandler;
import nl.nn.adapterframework.util.SpringUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.integration.IntegrationPatternType;
import org.springframework.messaging.Message;

public class HttpOutboundGateway<T>
implements InitializingBean,
ApplicationContextAware,
OutboundGateway<T> {
    private HttpOutboundHandler handler;
    private ApplicationContext applicationContext;
    @Value(value="${management.gateway.http.outbound.endpoint}")
    private String endpoint;

    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isBlank((CharSequence)this.endpoint)) {
            throw new IllegalStateException("no endpoint specified");
        }
        this.handler = new HttpOutboundHandler(this.endpoint);
        SpringUtils.autowireByType((ApplicationContext)this.applicationContext, (Object)((Object)this.handler));
    }

    @Override
    public Message<T> sendSyncMessage(Message<T> in) {
        return this.handler.handleRequestMessage(in);
    }

    @Override
    public void sendAsyncMessage(Message<T> in) {
        this.handler.handleRequestMessage(in);
    }

    public IntegrationPatternType getIntegrationPatternType() {
        return IntegrationPatternType.outbound_gateway;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

