/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.util;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import nl.nn.adapterframework.management.bus.BusException;
import org.apache.commons.lang3.NotImplementedException;

public class JacksonUtils {
    private static final ObjectMapper MAPPER = ((JsonMapper.Builder)JsonMapper.builder().enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).build();

    public static String convertToJson(Object payload) {
        try {
            return MAPPER.writeValueAsString(payload);
        }
        catch (JacksonException e) {
            throw new BusException("unable to convert response to JSON", e);
        }
    }

    public static <T> T convertToDTO(Object payload, Class<T> dto) {
        try {
            if (payload instanceof String) {
                return (T)MAPPER.readValue((String)payload, dto);
            }
            if (payload instanceof byte[]) {
                return (T)MAPPER.readValue((byte[])payload, dto);
            }
            throw new NotImplementedException("unhandled payload type [" + payload.getClass() + "]");
        }
        catch (JacksonException e) {
            throw new BusException("unable to convert payload", e);
        }
        catch (IOException e) {
            throw new BusException("unable to parse payload", e);
        }
    }

    static {
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MAPPER.configure(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT, true);
        MAPPER.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
    }
}

