/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.extensions.akamai;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import nl.nn.adapterframework.stream.Message;
import nl.nn.adapterframework.util.Misc;

public enum HashAlgorithm {
    MD5("MD5"),
    SHA1("SHA-1"),
    SHA256("SHA-256");

    private final String algorithm;

    private HashAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String computeHash(Message file) throws IOException {
        byte[] fileBytes = file.asByteArray();
        if (fileBytes == null) {
            throw new IllegalStateException("unable to compute hash over null message");
        }
        byte[] checksum = HashAlgorithm.computeHash(fileBytes, this);
        if (checksum != null) {
            return Misc.asHex((byte[])checksum);
        }
        throw new IllegalStateException("error computing checksum");
    }

    private static byte[] computeHash(byte[] srcBytes, HashAlgorithm hashAlgorithm) {
        try {
            MessageDigest digest = MessageDigest.getInstance(hashAlgorithm.getAlgorithm());
            return digest.digest(srcBytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("This should never happen! We are using an enum!", e);
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }
}

