/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.extensions.akamai;

import java.net.URI;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import nl.nn.adapterframework.extensions.akamai.NetStorageRequest;
import nl.nn.adapterframework.extensions.akamai.NetStorageUtils;
import nl.nn.adapterframework.util.CredentialFactory;

public class NetStorageCmsSigner {
    protected static final String ACTION_HEADER = "X-Akamai-ACS-Action";
    protected static final String AUTH_DATA_HEADER = "X-Akamai-ACS-Auth-Data";
    protected static final String AUTH_SIGN_HEADER = "X-Akamai-ACS-Auth-Sign";
    private URI uri;
    private String nonce;
    private String accessToken;
    private SignType signType;

    public NetStorageCmsSigner(URI uri, String nonce, String accessToken) {
        this(uri, nonce, accessToken, SignType.HMACSHA256);
    }

    public NetStorageCmsSigner(URI uri, String nonce, String accessToken, SignType signType) {
        this.uri = uri;
        this.nonce = nonce;
        this.accessToken = accessToken;
        this.signType = signType;
    }

    public NetStorageCmsSigner(URI uri, CredentialFactory accessTokenCf, SignType signType) {
        this(uri, accessTokenCf.getUsername(), accessTokenCf.getPassword(), signType);
    }

    protected String getActionHeaderValue(NetStorageRequest action) {
        return action.compileHeader();
    }

    protected String getAuthDataHeaderValue() {
        Date currentTime = new Date();
        int rand = new Random().nextInt(Integer.MAX_VALUE);
        return String.format("%d, 0.0.0.0, 0.0.0.0, %d, %d, %s", this.signType.getValue(), currentTime.getTime() / 1000L, rand, this.nonce);
    }

    protected String getAuthSignHeaderValue(String action, String authData) {
        String signData = String.format("%s%s\n%s:%s\n", authData, this.uri.getPath(), ACTION_HEADER.toLowerCase(), action);
        byte[] hash = NetStorageUtils.computeKeyedHash(signData.getBytes(), this.accessToken, this.signType.getAlgorithm());
        return NetStorageUtils.encodeBase64(hash);
    }

    public Map<String, String> computeHeaders(NetStorageRequest netStorageAction) {
        HashMap<String, String> headers = new HashMap<String, String>(3);
        String action = this.getActionHeaderValue(netStorageAction);
        String authData = this.getAuthDataHeaderValue();
        String authSign = this.getAuthSignHeaderValue(action, authData);
        headers.put(ACTION_HEADER, action);
        headers.put(AUTH_DATA_HEADER, authData);
        headers.put(AUTH_SIGN_HEADER, authSign);
        return headers;
    }

    public static enum SignType {
        HMACMD5(NetStorageUtils.KeyedHashAlgorithm.HMACMD5, 3),
        HMACSHA1(NetStorageUtils.KeyedHashAlgorithm.HMACSHA1, 4),
        HMACSHA256(NetStorageUtils.KeyedHashAlgorithm.HMACSHA256, 5);

        private final int value;
        private final NetStorageUtils.KeyedHashAlgorithm algorithm;

        private SignType(NetStorageUtils.KeyedHashAlgorithm algorithm, int value) {
            this.value = value;
            this.algorithm = algorithm;
        }

        public int getValue() {
            return this.value;
        }

        public NetStorageUtils.KeyedHashAlgorithm getAlgorithm() {
            return this.algorithm;
        }
    }
}

