/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.extensions.akamai;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import nl.nn.adapterframework.core.SenderException;
import nl.nn.adapterframework.extensions.akamai.HashAlgorithm;
import nl.nn.adapterframework.extensions.akamai.NetStorageCmsSigner;
import nl.nn.adapterframework.extensions.akamai.NetStorageSender;
import nl.nn.adapterframework.extensions.akamai.NetStorageUtils;
import nl.nn.adapterframework.http.HttpSenderBase;
import nl.nn.adapterframework.parameters.ParameterValueList;
import nl.nn.adapterframework.stream.Message;
import nl.nn.adapterframework.util.EnumUtils;
import nl.nn.adapterframework.util.LogUtil;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.logging.log4j.Logger;

public class NetStorageRequest {
    private Logger log = LogUtil.getLogger(NetStorageRequest.class);
    private int version = 1;
    private Message file = null;
    private NetStorageSender.Action action = null;
    private HashAlgorithm hashAlgorithm = null;
    private Map<String, String> actionHeader = new HashMap<String, String>();
    private HttpRequestBase method;

    protected NetStorageRequest(NetStorageSender.Action action) {
        this(null, action);
    }

    public NetStorageRequest(URI uri, NetStorageSender.Action action) {
        this.action = action;
        this.actionHeader.put("action", action.name().toLowerCase());
        switch (action) {
            case DIR: 
            case DU: 
            case DOWNLOAD: {
                this.method = new HttpGet(uri);
                break;
            }
            case DELETE: 
            case UPLOAD: 
            case MKDIR: {
                this.method = new HttpPut(uri);
                break;
            }
            case RMDIR: 
            case RENAME: 
            case MTIME: {
                this.method = new HttpPost(uri);
                break;
            }
            default: {
                throw new NotImplementedException("unknown action [" + (Object)((Object)action) + "]");
            }
        }
    }

    public String compileHeader() {
        if (this.method instanceof HttpGet) {
            this.actionHeader.put("format", "xml");
        }
        this.actionHeader.put("version", this.version + "");
        return NetStorageUtils.convertMapAsQueryParams(this.actionHeader);
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void mapParameters(ParameterValueList pvl) throws SenderException {
        if (this.action == NetStorageSender.Action.UPLOAD && pvl.contains("file")) {
            this.file = pvl.getParameterValue("file").asMessage();
            if (Message.isEmpty((Message)this.file)) {
                throw new SenderException("no file specified");
            }
            if (this.hashAlgorithm != null) {
                try {
                    this.generateHash(pvl);
                }
                catch (IOException e) {
                    throw new SenderException("error while calculating [" + (Object)((Object)this.hashAlgorithm) + "] hash", (Throwable)e);
                }
            }
            try {
                this.setEntity(this.file);
            }
            catch (IOException e) {
                throw new SenderException("unable to parse file", (Throwable)e);
            }
            if (pvl.contains("size")) {
                int size = pvl.getParameterValue("size").asIntegerValue(0);
                this.actionHeader.put("size", size + "");
            }
        }
        if (this.action == NetStorageSender.Action.RENAME && pvl.contains("destination")) {
            String destination = pvl.getParameterValue("destination").asStringValue(null);
            this.actionHeader.put("destination", destination);
        }
        if (pvl.contains("mtime")) {
            long mtime = pvl.getParameterValue("mtime").asLongValue(-1L);
            this.actionHeader.put("mtime", mtime + "");
        }
    }

    private void generateHash(ParameterValueList pvl) throws IOException {
        String hash = null;
        String algorithm = this.hashAlgorithm.name().toLowerCase();
        hash = pvl.contains("hashValue") ? pvl.getParameterValue("hashValue").asStringValue(null) : (pvl.contains(algorithm) ? pvl.getParameterValue(algorithm).asStringValue(null) : this.hashAlgorithm.computeHash(this.file));
        if (StringUtils.isNotEmpty((CharSequence)hash)) {
            this.actionHeader.put(algorithm, hash);
        }
    }

    public HttpSenderBase.HttpMethod getMethodType() {
        return (HttpSenderBase.HttpMethod)EnumUtils.parse(HttpSenderBase.HttpMethod.class, (String)this.method.getMethod());
    }

    private void setEntity(Message file) throws IOException {
        HttpEntity entity = this.toEntity(file);
        ((HttpEntityEnclosingRequestBase)this.method).setEntity(entity);
    }

    private HttpEntity toEntity(Message file) throws IOException {
        if (file.requiresStream()) {
            return new InputStreamEntity(file.asInputStream());
        }
        return new ByteArrayEntity(file.asByteArray());
    }

    public void sign(NetStorageCmsSigner signer) {
        Map<String, String> headers = signer.computeHeaders(this);
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("append header [" + entry.getKey() + "] with value [" + entry.getValue() + "]");
            }
            this.method.setHeader(entry.getKey(), entry.getValue());
        }
    }

    public HttpRequestBase build() {
        return this.method;
    }

    public void setHashAlgorithm(HashAlgorithm hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }
}

