/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.extensions.akamai;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServletResponse;
import nl.nn.adapterframework.configuration.ConfigurationException;
import nl.nn.adapterframework.configuration.ConfigurationWarnings;
import nl.nn.adapterframework.core.IConfigurationAware;
import nl.nn.adapterframework.core.PipeLineSession;
import nl.nn.adapterframework.core.SenderException;
import nl.nn.adapterframework.core.TimeoutException;
import nl.nn.adapterframework.doc.IbisDoc;
import nl.nn.adapterframework.extensions.akamai.HashAlgorithm;
import nl.nn.adapterframework.extensions.akamai.NetStorageCmsSigner;
import nl.nn.adapterframework.extensions.akamai.NetStorageRequest;
import nl.nn.adapterframework.http.HttpResponseHandler;
import nl.nn.adapterframework.http.HttpSenderBase;
import nl.nn.adapterframework.parameters.Parameter;
import nl.nn.adapterframework.parameters.ParameterList;
import nl.nn.adapterframework.parameters.ParameterValueList;
import nl.nn.adapterframework.stream.Message;
import nl.nn.adapterframework.util.CredentialFactory;
import nl.nn.adapterframework.util.LogUtil;
import nl.nn.adapterframework.util.Misc;
import nl.nn.adapterframework.util.XmlBuilder;
import nl.nn.adapterframework.util.XmlUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URIBuilder;
import org.apache.logging.log4j.Logger;

public class NetStorageSender
extends HttpSenderBase {
    private Logger log = LogUtil.getLogger(NetStorageSender.class);
    private static final String URL_PARAM_KEY = "urlParameter";
    public static final String DESTINATION_PARAM_KEY = "destination";
    public static final String FILE_PARAM_KEY = "file";
    public static final String MTIME_PARAM_KEY = "mtime";
    public static final String HASHVALUE_PARAM_KEY = "hashValue";
    private Action action = null;
    private int signVersion = 5;
    private int actionVersion = 1;
    private String rootDir = null;
    private HashAlgorithm hashAlgorithm = null;
    private String cpCode = null;
    private String authAlias = null;
    private String nonce = null;
    private String accessToken = null;
    private CredentialFactory accessTokenCf = null;

    public void configure() throws ConfigurationException {
        Parameter urlParameter = new Parameter();
        urlParameter.setName(this.getUrlParam());
        urlParameter.setSessionKey(URL_PARAM_KEY);
        this.addParameter(urlParameter);
        super.configure();
        if (this.getAction() == null) {
            throw new ConfigurationException(this.getLogPrefix() + "action must be specified");
        }
        if (this.getCpCode() == null) {
            throw new ConfigurationException(this.getLogPrefix() + "cpCode must be specified");
        }
        if (!this.getUrl().startsWith("http")) {
            throw new ConfigurationException(this.getLogPrefix() + "url must be start with http(s)");
        }
        if (this.getSignVersion() < 3 || this.getSignVersion() > 5) {
            throw new ConfigurationException(this.getLogPrefix() + "signVersion must be either 3, 4 or 5");
        }
        ParameterList parameterList = this.getParameterList();
        if (this.getAction() == Action.UPLOAD && parameterList.findParameter(FILE_PARAM_KEY) == null) {
            throw new ConfigurationException(this.getLogPrefix() + "the upload action requires a file parameter to be present");
        }
        if (this.getAction() == Action.RENAME && parameterList.findParameter(DESTINATION_PARAM_KEY) == null) {
            throw new ConfigurationException(this.getLogPrefix() + "the rename action requires a destination parameter to be present");
        }
        if (this.getAction() == Action.MTIME && parameterList.findParameter(MTIME_PARAM_KEY) == null) {
            throw new ConfigurationException(this.getLogPrefix() + "the mtime action requires a mtime parameter to be present");
        }
        for (HashAlgorithm algorithm : HashAlgorithm.values()) {
            String simpleName = algorithm.name().toLowerCase();
            Parameter hashValue = parameterList.findParameter(simpleName);
            if (hashValue == null) continue;
            this.setHashAlgorithm(algorithm);
            ConfigurationWarnings.add((IConfigurationAware)this, (Logger)this.log, (String)("deprecated parameter [" + simpleName + "]: please use attribute [hashAlgorithm] in combination with parameter [" + HASHVALUE_PARAM_KEY + "]"));
        }
        this.accessTokenCf = new CredentialFactory(this.getAuthAlias(), this.getNonce(), this.getAccessToken());
    }

    protected URI getURI(String path) throws URISyntaxException {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        String url = this.getUrl() + this.getCpCode();
        if (this.getRootDir() != null) {
            url = url + this.getRootDir();
        }
        if ((url = url + path).endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return new URIBuilder(url).build();
    }

    public Message sendMessage(Message message, PipeLineSession session) throws SenderException, TimeoutException {
        String path;
        try {
            path = message.asString();
        }
        catch (IOException e) {
            throw new SenderException(this.getLogPrefix(), (Throwable)e);
        }
        session.put((Object)URL_PARAM_KEY, (Object)path);
        return super.sendMessage(new Message(""), session);
    }

    public HttpRequestBase getMethod(URI uri, Message message, ParameterValueList parameters, PipeLineSession session) throws SenderException {
        NetStorageRequest request = new NetStorageRequest(uri, this.getAction());
        request.setVersion(this.actionVersion);
        request.setHashAlgorithm(this.hashAlgorithm);
        if (parameters != null) {
            request.mapParameters(parameters);
        }
        this.setMethodType(request.getMethodType());
        if (this.log.isDebugEnabled()) {
            this.log.debug("opening [" + request.getMethodType() + "] connection to [" + uri + "] with action [" + (Object)((Object)this.getAction()) + "]");
        }
        NetStorageCmsSigner signer = new NetStorageCmsSigner(uri, this.accessTokenCf, this.getSignType());
        request.sign(signer);
        return request.build();
    }

    public Message extractResult(HttpResponseHandler responseHandler, PipeLineSession session) throws SenderException, IOException {
        int statusCode = responseHandler.getStatusLine().getStatusCode();
        boolean ok = false;
        if (StringUtils.isNotEmpty((CharSequence)this.getResultStatusCodeSessionKey())) {
            session.put((Object)this.getResultStatusCodeSessionKey(), (Object)Integer.toString(statusCode));
            ok = true;
        } else if (statusCode == 200) {
            ok = true;
        } else if (this.isFollowRedirects() && statusCode == 301 || statusCode == 302 || statusCode == 307) {
            ok = true;
        }
        if (!ok) {
            throw new SenderException(this.getLogPrefix() + "httpstatus " + statusCode + ": " + responseHandler.getStatusLine().getReasonPhrase() + " body: " + this.getResponseBodyAsString(responseHandler, false));
        }
        XmlBuilder result = new XmlBuilder("result");
        HttpServletResponse response = (HttpServletResponse)session.get((Object)"servletResponse");
        if (response == null) {
            XmlBuilder statuscode = new XmlBuilder("statuscode");
            statuscode.setValue(statusCode + "");
            result.addSubElement(statuscode);
            String responseString = this.getResponseBodyAsString(responseHandler, true);
            responseString = XmlUtils.skipDocTypeDeclaration((String)responseString.trim());
            responseString = XmlUtils.skipXmlDeclaration((String)responseString);
            if (statusCode == 200) {
                XmlBuilder message = new XmlBuilder("message");
                message.setValue(responseString, false);
                result.addSubElement(message);
            } else {
                String dateString = responseHandler.getHeader("Date");
                if (!StringUtils.isEmpty((CharSequence)dateString)) {
                    Date currentDate = new Date();
                    SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.ENGLISH);
                    long responseDate = 0L;
                    try {
                        Date date = format.parse(dateString);
                        responseDate = date.getTime();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (responseDate != 0L && currentDate.getTime() - responseDate > 30000L) {
                        throw new SenderException("Local server Date is more than 30s out of sync with Remote server");
                    }
                }
                XmlBuilder message = new XmlBuilder("error");
                message.setValue(responseString);
                result.addSubElement(message);
                this.log.warn(String.format("Unexpected Response from Server: %d %s\n%s", statusCode, responseString, responseHandler.getHeaderFields()));
            }
        }
        return Message.asMessage((Object)result.toXML());
    }

    public String getResponseBodyAsString(HttpResponseHandler responseHandler, boolean throwIOExceptionWhenParsingResponse) throws IOException {
        String charset = responseHandler.getCharset();
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.getLogPrefix() + "response body uses charset [" + charset + "]");
        }
        Message response = responseHandler.getResponseMessage();
        String responseBody = null;
        try {
            responseBody = response.asString();
        }
        catch (IOException e) {
            if (throwIOExceptionWhenParsingResponse) {
                throw e;
            }
            return null;
        }
        int rbLength = responseBody.length();
        long rbSizeWarn = Misc.getResponseBodySizeWarnByDefault();
        if ((long)rbLength >= rbSizeWarn) {
            this.log.warn(this.getLogPrefix() + "retrieved result size [" + Misc.toFileSize((long)rbLength) + "] exceeds [" + Misc.toFileSize((long)rbSizeWarn) + "]");
        }
        return responseBody;
    }

    public void setHashAlgorithm(HashAlgorithm hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public void setActionVersion(int actionVersion) {
        this.actionVersion = actionVersion;
    }

    public void setCpCode(String cpCode) {
        this.cpCode = cpCode;
    }

    public void setUrl(String url) {
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        super.setUrl(url);
    }

    @IbisDoc(value={"the nonce or api username", ""})
    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    @IbisDoc(value={"the version used to sign the authentication headers. possible values: 3 (md5), 4 (sha1), 5 (sha256)", "5"})
    public void setSignVersion(int signVersion) {
        this.signVersion = signVersion;
    }

    public NetStorageCmsSigner.SignType getSignType() {
        if (this.getSignVersion() == 3) {
            return NetStorageCmsSigner.SignType.HMACMD5;
        }
        if (this.getSignVersion() == 4) {
            return NetStorageCmsSigner.SignType.HMACSHA1;
        }
        return NetStorageCmsSigner.SignType.HMACSHA256;
    }

    @IbisDoc(value={"the api accesstoken", ""})
    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getPhysicalDestinationName() {
        return "URL [" + this.getUrl() + "] cpCode [" + this.getCpCode() + "] action [" + (Object)((Object)this.getAction()) + "]";
    }

    public void setRootDir(String rootDir) {
        if (!rootDir.startsWith("/")) {
            rootDir = "/" + rootDir;
        }
        if (rootDir.endsWith("/")) {
            rootDir = rootDir.substring(0, rootDir.length() - 1);
        }
        this.rootDir = rootDir;
    }

    public void setAuthAlias(String authAlias) {
        this.authAlias = authAlias;
    }

    public Action getAction() {
        return this.action;
    }

    public int getSignVersion() {
        return this.signVersion;
    }

    public int getActionVersion() {
        return this.actionVersion;
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public String getCpCode() {
        return this.cpCode;
    }

    public String getAuthAlias() {
        return this.authAlias;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public static enum Action {
        DU,
        DIR,
        DELETE,
        UPLOAD,
        MKDIR,
        RMDIR,
        RENAME,
        MTIME,
        DOWNLOAD;

    }
}

