/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.extensions.akamai;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.TreeSet;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import nl.nn.adapterframework.util.StreamUtil;

public class NetStorageUtils {
    private static final char[] BASE64_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();

    public static byte[] computeKeyedHash(byte[] data, String key, KeyedHashAlgorithm hashType) {
        if (data == null || key == null) {
            return null;
        }
        try {
            Mac mac = Mac.getInstance(hashType.getAlgorithm());
            mac.init(new SecretKeySpec(key.getBytes(), hashType.getAlgorithm()));
            return mac.doFinal(data);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("This should never happen!", e);
        }
    }

    public static String encodeBase64(byte[] value) {
        if (value == null) {
            return null;
        }
        StringBuilder result = new StringBuilder("");
        for (int i = 0; i < value.length; i += 3) {
            int c = 2;
            int v = (value[i] & 0xFF) << 16;
            if (i + 1 < value.length) {
                v |= (value[i + 1] & 0xFF) << 8;
                c = 3;
            }
            if (i + 2 < value.length) {
                v |= value[i + 2] & 0xFF;
                c = 4;
            }
            result.append(BASE64_CHARS[v >> 18 & 0x3F]);
            result.append(BASE64_CHARS[v >> 12 & 0x3F]);
            result.append(c >= 3 ? BASE64_CHARS[v >> 6 & 0x3F] : (char)'=');
            result.append(c == 4 ? BASE64_CHARS[v & 0x3F] : (char)'=');
        }
        return result.toString();
    }

    public static String convertMapAsQueryParams(Map<String, String> data) {
        StringBuilder result = new StringBuilder();
        try {
            for (String entry : new TreeSet<String>(data.keySet())) {
                result.append(String.format("%s%s=%s", result.length() > 0 ? "&" : "", URLEncoder.encode(entry, StreamUtil.DEFAULT_INPUT_STREAM_ENCODING), URLEncoder.encode(data.get(entry), StreamUtil.DEFAULT_INPUT_STREAM_ENCODING)));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("This should never happen! StandardCharsets.UTF_8 is an enum!", e);
        }
        return result.toString();
    }

    public static enum KeyedHashAlgorithm {
        HMACMD5("HmacMD5"),
        HMACSHA1("HmacSHA1"),
        HMACSHA256("HmacSHA256");

        private final String algorithm;

        private KeyedHashAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }
    }
}

