/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.management.web;

import java.io.IOException;
import java.lang.reflect.Method;
import javax.annotation.Priority;
import javax.annotation.security.DenyAll;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import nl.nn.adapterframework.management.bus.BusMessageUtils;
import org.apache.cxf.interceptor.security.AccessDeniedException;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;

@Provider
@Priority(value=2000)
public class AuthorizationFilter
implements ContainerRequestFilter {
    private static final Response FORBIDDEN = Response.status((Response.Status)Response.Status.FORBIDDEN).build();

    public void filter(ContainerRequestContext requestContext) throws IOException {
        RolesAllowed rolesAnnotation;
        if (requestContext.getMethod().equalsIgnoreCase("OPTIONS")) {
            return;
        }
        Message message = JAXRSUtils.getCurrentMessage();
        Method method = (Method)MessageUtils.getTargetMethod((Message)message).orElseThrow(() -> new AccessDeniedException("Unauthorized"));
        if (method.isAnnotationPresent(DenyAll.class)) {
            requestContext.abortWith(FORBIDDEN);
            return;
        }
        if (method.isAnnotationPresent(RolesAllowed.class) && !BusMessageUtils.hasAnyRole((String[])(rolesAnnotation = method.getAnnotation(RolesAllowed.class)).value())) {
            requestContext.abortWith(FORBIDDEN);
        }
    }
}

