/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.management.web;

import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import nl.nn.adapterframework.management.bus.BusAction;
import nl.nn.adapterframework.management.bus.BusTopic;
import nl.nn.adapterframework.management.web.ApiException;
import nl.nn.adapterframework.management.web.FrankApiBase;
import nl.nn.adapterframework.management.web.RequestMessageBuilder;
import nl.nn.adapterframework.util.RequestUtils;
import org.apache.commons.lang3.StringUtils;

@Path(value="/")
public final class BrowseJdbcTable
extends FrankApiBase {
    @POST
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/jdbc/browse")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response execute(Map<String, Object> json) {
        String datasource = RequestUtils.getValue(json, "datasource");
        String tableName = RequestUtils.getValue(json, "table");
        String where = RequestUtils.getValue(json, "where");
        String order = RequestUtils.getValue(json, "order");
        Boolean numberOfRowsOnly = RequestUtils.getBooleanValue(json, "numberOfRowsOnly");
        Integer minRow = RequestUtils.getIntegerValue(json, "minRow");
        Integer maxRow = RequestUtils.getIntegerValue(json, "maxRow");
        if (tableName == null) {
            throw new ApiException("tableName not defined.", 400);
        }
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.JDBC, BusAction.FIND);
        if (StringUtils.isNotEmpty((CharSequence)datasource)) {
            builder.addHeader("datasourceName", datasource);
        }
        builder.addHeader("table", tableName);
        builder.addHeader("where", where);
        builder.addHeader("order", order);
        builder.addHeader("numberOfRowsOnly", numberOfRowsOnly);
        builder.addHeader("minRow", minRow);
        builder.addHeader("maxRow", maxRow);
        return this.callSyncGateway(builder);
    }
}

