/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.management.web;

import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import nl.nn.adapterframework.management.bus.BusAction;
import nl.nn.adapterframework.management.bus.BusTopic;
import nl.nn.adapterframework.management.web.ApiException;
import nl.nn.adapterframework.management.web.FrankApiBase;
import nl.nn.adapterframework.management.web.RequestMessageBuilder;
import nl.nn.adapterframework.util.RequestUtils;
import org.apache.commons.lang3.StringUtils;

@Path(value="/")
public final class BrowseQueue
extends FrankApiBase {
    @GET
    @RolesAllowed(value={"IbisObserver", "IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="jms")
    @Produces(value={"application/json"})
    public Response getBrowseQueue() {
        return this.callSyncGateway(RequestMessageBuilder.create(this, BusTopic.QUEUE, BusAction.GET));
    }

    @POST
    @RolesAllowed(value={"IbisObserver", "IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="jms/browse")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response putBrowseQueue(Map<String, Object> json) {
        String connectionFactory = RequestUtils.getValue(json, "connectionFactory");
        String destination = RequestUtils.getValue(json, "destination");
        Boolean rowNumbersOnly = RequestUtils.getBooleanValue(json, "rowNumbersOnly");
        Boolean showPayload = RequestUtils.getBooleanValue(json, "payload");
        Boolean lookupDestination = RequestUtils.getBooleanValue(json, "lookupDestination");
        String type = RequestUtils.getValue(json, "type");
        if (StringUtils.isNotEmpty((CharSequence)destination)) {
            throw new ApiException("No destination provided");
        }
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            throw new ApiException("No type provided");
        }
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.QUEUE, BusAction.FIND);
        builder.addHeader("connectionFactory", connectionFactory);
        builder.addHeader("destination", destination);
        builder.addHeader("type", type);
        if (rowNumbersOnly != null) {
            builder.addHeader("rowNumbersOnly", rowNumbersOnly);
        }
        if (showPayload != null) {
            builder.addHeader("showPayload", showPayload);
        }
        if (lookupDestination != null) {
            builder.addHeader("lookupDestination", lookupDestination);
        }
        return this.callSyncGateway(builder);
    }
}

