/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.management.web;

import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import nl.nn.adapterframework.management.bus.BusAction;
import nl.nn.adapterframework.management.bus.BusTopic;
import nl.nn.adapterframework.management.web.FrankApiBase;
import nl.nn.adapterframework.management.web.Relation;
import nl.nn.adapterframework.management.web.RequestMessageBuilder;
import nl.nn.adapterframework.management.web.ShowScheduler;
import nl.nn.adapterframework.util.RequestUtils;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;

@Path(value="/")
public final class CompatibilityShowScheduler
extends FrankApiBase {
    @GET
    @RolesAllowed(value={"IbisObserver", "IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/schedules/{groupName}/job/{jobName}")
    @Relation(value="schedules")
    @Produces(value={"application/json"})
    @Deprecated
    public Response getScheduleOld(@PathParam(value="jobName") String jobName, @PathParam(value="groupName") String groupName) {
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.SCHEDULER, BusAction.FIND);
        builder.addHeader("job", jobName);
        builder.addHeader("group", groupName);
        return this.callSyncGateway(builder);
    }

    @PUT
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/schedules/{groupName}/job/{jobName}")
    @Relation(value="schedules")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Deprecated
    public Response triggerOld(@PathParam(value="jobName") String jobName, @PathParam(value="groupName") String groupName, Map<String, Object> json) {
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.SCHEDULER, BusAction.MANAGE);
        builder.addHeader("operation", RequestUtils.getValue(json, "action"));
        builder.addHeader("job", jobName);
        builder.addHeader("group", groupName);
        return this.callSyncGateway(builder);
    }

    @PUT
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/schedules/{groupName}/job/{jobName}")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @Deprecated
    public Response updateScheduleOld(@PathParam(value="groupName") String groupName, @PathParam(value="jobName") String jobName, MultipartBody input) {
        return ShowScheduler.createSchedule(this, groupName, jobName, input, true);
    }

    @POST
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/schedules/{groupName}/job")
    @Relation(value="schedules")
    @Produces(value={"application/json"})
    @Deprecated
    public Response createScheduleInJobGroupOld(@PathParam(value="groupName") String groupName, MultipartBody input) {
        String jobName = RequestUtils.resolveStringFromMap(input, "name");
        return ShowScheduler.createSchedule(this, groupName, jobName, input, false);
    }

    @DELETE
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/schedules/{groupName}/job/{jobName}")
    @Relation(value="schedules")
    @Produces(value={"application/json"})
    @Deprecated
    public Response deleteSchedulesOld(@PathParam(value="jobName") String jobName, @PathParam(value="groupName") String groupName) {
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.SCHEDULER, BusAction.DELETE);
        builder.addHeader("job", jobName);
        builder.addHeader("group", groupName);
        return this.callSyncGateway(builder);
    }
}

