/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.management.web;

import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import nl.nn.adapterframework.management.bus.BusAction;
import nl.nn.adapterframework.management.bus.BusTopic;
import nl.nn.adapterframework.management.web.ApiException;
import nl.nn.adapterframework.management.web.FrankApiBase;
import nl.nn.adapterframework.management.web.RequestMessageBuilder;
import nl.nn.adapterframework.util.RequestUtils;

@Path(value="/")
public final class ExecuteJdbcQuery
extends FrankApiBase {
    @GET
    @RolesAllowed(value={"IbisObserver", "IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/jdbc")
    @Produces(value={"application/json"})
    public Response getJdbcInfo() throws ApiException {
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.JDBC, BusAction.GET);
        return this.callSyncGateway(builder);
    }

    @POST
    @RolesAllowed(value={"IbisTester"})
    @Path(value="/jdbc/query")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response execute(Map<String, Object> json) {
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.JDBC, BusAction.MANAGE);
        String datasource = RequestUtils.getValue(json, "datasource");
        String query = RequestUtils.getValue(json, "query");
        String resultType = RequestUtils.getValue(json, "resultType");
        if (resultType == null || query == null) {
            throw new ApiException("Missing data, datasource, resultType and query are expected.", 400);
        }
        builder.addHeader("query", query);
        builder.addHeader("resultType", resultType);
        builder.addHeader("avoidLocking", RequestUtils.getBooleanValue(json, "avoidLocking"));
        builder.addHeader("trimSpaces", RequestUtils.getBooleanValue(json, "trimSpaces"));
        String queryType = RequestUtils.getValue(json, "queryType");
        if ("AUTO".equals(queryType)) {
            String[] commands;
            queryType = "other";
            for (String command : commands = new String[]{"select", "show"}) {
                if (!query.toLowerCase().startsWith(command)) continue;
                queryType = "select";
                break;
            }
        }
        builder.addHeader("datasourceName", datasource);
        builder.addHeader("queryType", queryType);
        return this.callSyncGateway(builder);
    }
}

