/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.management.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import nl.nn.adapterframework.management.bus.BusAction;
import nl.nn.adapterframework.management.bus.BusTopic;
import nl.nn.adapterframework.management.web.ApiException;
import nl.nn.adapterframework.management.web.FrankApiBase;
import nl.nn.adapterframework.management.web.RequestMessageBuilder;
import nl.nn.adapterframework.util.RequestUtils;
import nl.nn.adapterframework.util.StreamUtil;
import nl.nn.adapterframework.util.XmlEncodingUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;

@Path(value="/")
public class SendJmsMessage
extends FrankApiBase {
    @POST
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="jms/message")
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    public Response putJmsMessage(MultipartBody inputDataMap) {
        String message = null;
        String fileName = null;
        InputStream file = null;
        if (inputDataMap == null) {
            throw new ApiException("Missing post parameters");
        }
        String fileEncoding = RequestUtils.resolveTypeFromMap(inputDataMap, "encoding", String.class, StreamUtil.DEFAULT_INPUT_STREAM_ENCODING);
        String connectionFactory = RequestUtils.resolveStringFromMap(inputDataMap, "connectionFactory");
        String destinationName = RequestUtils.resolveStringFromMap(inputDataMap, "destination");
        String destinationType = RequestUtils.resolveStringFromMap(inputDataMap, "type");
        String replyTo = RequestUtils.resolveTypeFromMap(inputDataMap, "replyTo", String.class, "");
        boolean persistent = RequestUtils.resolveTypeFromMap(inputDataMap, "persistent", Boolean.TYPE, false);
        boolean synchronous = RequestUtils.resolveTypeFromMap(inputDataMap, "synchronous", Boolean.TYPE, false);
        boolean lookupDestination = RequestUtils.resolveTypeFromMap(inputDataMap, "lookupDestination", Boolean.TYPE, false);
        String messageProperty = RequestUtils.resolveTypeFromMap(inputDataMap, "property", String.class, "");
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.QUEUE, BusAction.UPLOAD);
        builder.addHeader("connectionFactory", connectionFactory);
        builder.addHeader("destination", destinationName);
        builder.addHeader("type", destinationType);
        builder.addHeader("replyTo", replyTo);
        builder.addHeader("persistent", persistent);
        builder.addHeader("synchronous", synchronous);
        builder.addHeader("lookupDestination", lookupDestination);
        builder.addHeader("messageProperty", messageProperty);
        Attachment filePart = inputDataMap.getAttachment("file");
        if (filePart != null) {
            fileName = filePart.getContentDisposition().getParameter("filename");
            file = (InputStream)filePart.getObject(InputStream.class);
            if (StringUtils.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)".zip")) {
                try {
                    this.processZipFile(file, builder);
                    return Response.status((Response.Status)Response.Status.OK).build();
                }
                catch (IOException e) {
                    throw new ApiException("error processing zip file", e);
                }
            }
            try {
                message = XmlEncodingUtils.readXml((InputStream)file, (String)fileEncoding);
            }
            catch (UnsupportedEncodingException e) {
                throw new ApiException("unsupported file encoding [" + fileEncoding + "]");
            }
            catch (IOException e) {
                throw new ApiException("error reading file", e);
            }
        } else {
            message = RequestUtils.resolveStringWithEncoding(inputDataMap, "message", fileEncoding);
        }
        if (StringUtils.isEmpty((CharSequence)message)) {
            throw new ApiException("Neither a file nor a message was supplied", 400);
        }
        builder.setPayload(message);
        return synchronous ? this.callSyncGateway(builder) : this.callAsyncGateway(builder);
    }

    private void processZipFile(InputStream file, RequestMessageBuilder builder) throws IOException {
        ZipInputStream archive = new ZipInputStream(file);
        ZipEntry entry = archive.getNextEntry();
        while (entry != null) {
            int size = (int)entry.getSize();
            if (size > 0) {
                byte[] b = new byte[size];
                int rb = 0;
                int chunk = 0;
                while (size - rb > 0 && (chunk = archive.read(b, rb, size - rb)) != -1) {
                    rb += chunk;
                }
                String currentMessage = XmlEncodingUtils.readXml((byte[])b, null);
                builder.setPayload(currentMessage);
                this.callAsyncGateway(builder);
            }
            archive.closeEntry();
            entry = archive.getNextEntry();
        }
        archive.close();
    }
}

