/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.management.web;

import java.io.InputStream;
import java.util.Map;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import nl.nn.adapterframework.management.IbisAction;
import nl.nn.adapterframework.management.bus.BusAction;
import nl.nn.adapterframework.management.bus.BusTopic;
import nl.nn.adapterframework.management.web.ApiException;
import nl.nn.adapterframework.management.web.FrankApiBase;
import nl.nn.adapterframework.management.web.RequestMessageBuilder;
import nl.nn.adapterframework.util.HttpUtils;
import nl.nn.adapterframework.util.RequestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;

@Path(value="/")
public final class ShowConfiguration
extends FrankApiBase {
    @GET
    @RolesAllowed(value={"IbisObserver", "IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/configurations")
    @Produces(value={"application/xml"})
    public Response getXMLConfiguration(@QueryParam(value="loadedConfiguration") boolean loaded, @QueryParam(value="flow") String flow) throws ApiException {
        if (StringUtils.isNotEmpty((CharSequence)flow)) {
            RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.FLOW);
            return this.callSyncGateway(builder);
        }
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.CONFIGURATION, BusAction.GET);
        if (loaded) {
            builder.addHeader("loaded", loaded);
        }
        return this.callSyncGateway(builder);
    }

    @PUT
    @RolesAllowed(value={"IbisAdmin", "IbisTester"})
    @Path(value="/configurations")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response fullReload(Map<String, Object> json) throws ApiException {
        Object value = json.get("action");
        if (value instanceof String && "reload".equals(value)) {
            RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.IBISACTION);
            builder.addHeader("action", IbisAction.FULLRELOAD.name());
            this.callAsyncGateway(builder);
            return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)"{\"status\":\"ok\"}").build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @GET
    @RolesAllowed(value={"IbisObserver", "IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/configurations/{configuration}")
    @Produces(value={"application/xml"})
    public Response getConfigurationByName(@PathParam(value="configuration") String configurationName, @QueryParam(value="loadedConfiguration") boolean loaded) throws ApiException {
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.CONFIGURATION, BusAction.GET);
        builder.addHeader("configuration", configurationName);
        if (loaded) {
            builder.addHeader("loaded", loaded);
        }
        return this.callSyncGateway(builder);
    }

    @GET
    @PermitAll
    @Path(value="/configurations/{configuration}/health")
    @Produces(value={"application/json"})
    public Response getConfigurationHealth(@PathParam(value="configuration") String configurationName) throws ApiException {
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.HEALTH);
        builder.addHeader("configuration", configurationName);
        return this.callSyncGateway(builder);
    }

    @GET
    @RolesAllowed(value={"IbisObserver", "IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/configurations/{configuration}/flow")
    public Response getConfigurationFlow(@PathParam(value="configuration") String configurationName) throws ApiException {
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.FLOW);
        builder.addHeader("configuration", configurationName);
        return this.callSyncGateway(builder);
    }

    @PUT
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/configurations/{configuration}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response reloadConfiguration(@PathParam(value="configuration") String configurationName, Map<String, Object> json) throws ApiException {
        Object value = json.get("action");
        if (value instanceof String && "reload".equals(value)) {
            RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.IBISACTION);
            builder.addHeader("action", IbisAction.RELOAD.name());
            builder.addHeader("configuration", configurationName);
            this.callAsyncGateway(builder);
            return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)"{\"status\":\"ok\"}").build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @GET
    @RolesAllowed(value={"IbisObserver", "IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/configurations/{configuration}/versions")
    @Produces(value={"application/json"})
    public Response getConfigurationDetailsByName(@PathParam(value="configuration") String configurationName, @QueryParam(value="datasourceName") String datasourceName) throws ApiException {
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.CONFIGURATION, BusAction.FIND);
        builder.addHeader("configuration", configurationName);
        builder.addHeader("datasourceName", datasourceName);
        return this.callSyncGateway(builder);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PUT
    @RolesAllowed(value={"IbisTester", "IbisAdmin", "IbisDataAdmin"})
    @Path(value="/configurations/{configuration}/versions/{version}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response manageConfiguration(@PathParam(value="configuration") String configurationName, @PathParam(value="version") String encodedVersion, @QueryParam(value="datasourceName") String datasourceName, Map<String, Object> json) throws ApiException {
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.CONFIGURATION, BusAction.MANAGE);
        builder.addHeader("configuration", configurationName);
        builder.addHeader("version", HttpUtils.urlDecode((String)encodedVersion));
        if (json.containsKey("activate")) {
            Object obj = json.get("activate");
            if (!(obj instanceof Boolean)) throw new ApiException("activate must be of type boolean");
            builder.addHeader("activate", (Boolean)json.get("activate"));
        } else if (json.containsKey("autoreload")) {
            Object obj = json.get("autoreload");
            if (!(obj instanceof Boolean)) throw new ApiException("autoreload must be of type boolean");
            builder.addHeader("autoreload", (Boolean)json.get("autoreload"));
        }
        builder.addHeader("datasourceName", datasourceName);
        return this.callSyncGateway(builder);
    }

    @POST
    @RolesAllowed(value={"IbisTester", "IbisAdmin", "IbisDataAdmin"})
    @Path(value="configurations")
    @Produces(value={"application/json"})
    public Response uploadConfiguration(MultipartBody inputDataMap) throws ApiException {
        if (inputDataMap == null) {
            throw new ApiException("Missing post parameters");
        }
        String datasource = RequestUtils.resolveStringFromMap(inputDataMap, "datasource", "");
        boolean multipleConfigs = RequestUtils.resolveTypeFromMap(inputDataMap, "multiple_configs", Boolean.TYPE, false);
        boolean activateConfig = RequestUtils.resolveTypeFromMap(inputDataMap, "activate_config", Boolean.TYPE, true);
        boolean automaticReload = RequestUtils.resolveTypeFromMap(inputDataMap, "automatic_reload", Boolean.TYPE, false);
        InputStream file = RequestUtils.resolveTypeFromMap(inputDataMap, "file", InputStream.class, null);
        String user = RequestUtils.resolveTypeFromMap(inputDataMap, "user", String.class, "");
        if (StringUtils.isEmpty((CharSequence)user)) {
            user = this.getUserPrincipalName();
        }
        String fileName = inputDataMap.getAttachment("file").getContentDisposition().getParameter("filename");
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.CONFIGURATION, BusAction.UPLOAD);
        builder.setPayload(file);
        builder.addHeader("filename", fileName);
        builder.addHeader("multiple_configs", multipleConfigs);
        builder.addHeader("activate_config", activateConfig);
        builder.addHeader("automatic_reload", automaticReload);
        builder.addHeader("user", user);
        if (StringUtils.isNotEmpty((CharSequence)datasource)) {
            builder.addHeader("datasourceName", datasource);
        }
        return this.callSyncGateway(builder);
    }

    @GET
    @RolesAllowed(value={"IbisObserver", "IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/configurations/{configuration}/versions/{version}/download")
    @Produces(value={"application/octet-stream"})
    public Response downloadConfiguration(@PathParam(value="configuration") String configurationName, @PathParam(value="version") String version, @QueryParam(value="dataSourceName") String dataSourceName) throws ApiException {
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.CONFIGURATION, BusAction.DOWNLOAD);
        builder.addHeader("configuration", configurationName);
        builder.addHeader("version", version);
        builder.addHeader("datasourceName", dataSourceName);
        return this.callSyncGateway(builder);
    }

    @DELETE
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/configurations/{configuration}/versions/{version}")
    public Response deleteConfiguration(@PathParam(value="configuration") String configurationName, @PathParam(value="version") String version, @QueryParam(value="datasourceName") String datasourceName) throws ApiException {
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.CONFIGURATION, BusAction.DELETE);
        builder.addHeader("configuration", configurationName);
        builder.addHeader("version", version);
        builder.addHeader("datasourceName", datasourceName);
        return this.callAsyncGateway(builder);
    }
}

