/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.management.web;

import java.util.ArrayList;
import java.util.Map;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import nl.nn.adapterframework.management.IbisAction;
import nl.nn.adapterframework.management.bus.BusAction;
import nl.nn.adapterframework.management.bus.BusTopic;
import nl.nn.adapterframework.management.web.ApiException;
import nl.nn.adapterframework.management.web.FrankApiBase;
import nl.nn.adapterframework.management.web.RequestMessageBuilder;
import nl.nn.adapterframework.util.RequestUtils;
import org.apache.commons.lang3.StringUtils;

@Path(value="/")
public final class ShowConfigurationStatus
extends FrankApiBase {
    private static final String REDIRECT_MESSAGE_PREFIX = "either provide the configuration as query param or use endpoint /configurations/<config>";

    @GET
    @RolesAllowed(value={"IbisObserver", "IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/adapters")
    @Produces(value={"application/json"})
    public Response getAdapters(@QueryParam(value="expanded") String expanded, @QueryParam(value="showPendingMsgCount") boolean showPendingMsgCount) {
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.ADAPTER, BusAction.GET);
        builder.addHeader("showPendingMsgCount", showPendingMsgCount);
        builder.addHeader("expanded", expanded);
        return this.callSyncGateway(builder, true);
    }

    @GET
    @RolesAllowed(value={"IbisObserver", "IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/adapters/{name}")
    @Produces(value={"application/json"})
    @Deprecated
    public Response getAdapterOld(@PathParam(value="name") String name, @QueryParam(value="configuration") String configuration, @QueryParam(value="expanded") String expanded, @QueryParam(value="showPendingMsgCount") boolean showPendingMsgCount) {
        if (StringUtils.isNotEmpty((CharSequence)configuration)) {
            return this.getAdapter(configuration, name, expanded, showPendingMsgCount);
        }
        throw new ApiException("either provide the configuration as query param or use endpoint /configurations/<config>/adapters/" + name, Response.Status.BAD_REQUEST);
    }

    @GET
    @RolesAllowed(value={"IbisObserver", "IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/configurations/{configuration}/adapters/{name}")
    @Produces(value={"application/json"})
    public Response getAdapter(@PathParam(value="configuration") String configuration, @PathParam(value="name") String name, @QueryParam(value="expanded") String expanded, @QueryParam(value="showPendingMsgCount") boolean showPendingMsgCount) {
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.ADAPTER, BusAction.FIND);
        builder.addHeader("configuration", configuration);
        builder.addHeader("adapter", name);
        builder.addHeader("showPendingMsgCount", showPendingMsgCount);
        builder.addHeader("expanded", expanded);
        return this.callSyncGateway(builder, true);
    }

    @GET
    @PermitAll
    @Path(value="/adapters/{name}/health")
    @Produces(value={"application/json"})
    @Deprecated
    public Response getIbisHealthOld(@PathParam(value="name") String name, @QueryParam(value="configuration") String configuration) {
        if (StringUtils.isNotEmpty((CharSequence)configuration)) {
            return this.getIbisHealth(configuration, name);
        }
        throw new ApiException("either provide the configuration as query param or use endpoint /configurations/<config>/adapters/" + name + "/health", Response.Status.BAD_REQUEST);
    }

    @GET
    @PermitAll
    @Path(value="/configurations/{configuration}/adapters/{name}/health")
    @Produces(value={"application/json"})
    public Response getIbisHealth(@PathParam(value="configuration") String configuration, @PathParam(value="name") String name) {
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.HEALTH);
        builder.addHeader("configuration", configuration);
        builder.addHeader("adapter", name);
        return this.callSyncGateway(builder);
    }

    @PUT
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/adapters/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateAdapters(Map<String, Object> json) {
        IbisAction action = null;
        ArrayList adapters = new ArrayList();
        String value = RequestUtils.getValue(json, "action");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            if (value.equals("stop")) {
                action = IbisAction.STOPADAPTER;
            }
            if (value.equals("start")) {
                action = IbisAction.STARTADAPTER;
            }
        }
        if (action == null) {
            throw new ApiException("no or unknown action provided", Response.Status.BAD_REQUEST);
        }
        Object adapterList = json.get("adapters");
        if (adapterList != null) {
            try {
                adapters.addAll((ArrayList)adapterList);
            }
            catch (Exception e) {
                throw new ApiException(e);
            }
        }
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.IBISACTION);
        builder.addHeader("action", action.name());
        if (adapters.isEmpty()) {
            builder.addHeader("configuration", "*ALL*");
            builder.addHeader("adapter", "*ALL*");
            this.callAsyncGateway(builder);
        } else {
            for (String adapterNameWithPossibleConfigurationName : adapters) {
                String adapterName;
                int slash = adapterNameWithPossibleConfigurationName.indexOf("/");
                if (slash > -1) {
                    adapterName = adapterNameWithPossibleConfigurationName.substring(slash + 1);
                    String configurationName = adapterNameWithPossibleConfigurationName.substring(0, slash);
                    builder.addHeader("configuration", configurationName);
                } else {
                    adapterName = adapterNameWithPossibleConfigurationName;
                }
                builder.addHeader("adapter", adapterName);
                this.callAsyncGateway(builder);
            }
        }
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @PUT
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/adapters/{adapter}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Deprecated
    public Response updateAdapterOld(@PathParam(value="adapter") String adapter, @QueryParam(value="configuration") String configuration, Map<String, Object> json) {
        if (StringUtils.isNotEmpty((CharSequence)configuration)) {
            return this.updateAdapter(configuration, adapter, json);
        }
        throw new ApiException("either provide the configuration as query param or use endpoint /configurations/<config>/adapters/" + adapter, Response.Status.BAD_REQUEST);
    }

    @PUT
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/configurations/{configuration}/adapters/{adapter}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateAdapter(@PathParam(value="configuration") String configuration, @PathParam(value="adapter") String adapter, Map<String, Object> json) {
        Object value = json.get("action");
        if (value instanceof String) {
            IbisAction action = null;
            if (value.equals("stop")) {
                action = IbisAction.STOPADAPTER;
            }
            if (value.equals("start")) {
                action = IbisAction.STARTADAPTER;
            }
            if (action == null) {
                throw new ApiException("no or unknown action provided", Response.Status.BAD_REQUEST);
            }
            RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.IBISACTION);
            builder.addHeader("action", action.name());
            builder.addHeader("configuration", configuration);
            builder.addHeader("adapter", adapter);
            this.callAsyncGateway(builder);
            return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)"{\"status\":\"ok\"}").build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @PUT
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/adapters/{adapter}/receivers/{receiver}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Deprecated
    public Response updateReceiverOld(@QueryParam(value="configuration") String configuration, @PathParam(value="adapter") String adapter, @PathParam(value="receiver") String receiver, Map<String, Object> json) {
        if (StringUtils.isNotEmpty((CharSequence)configuration)) {
            return this.updateReceiverOld(configuration, adapter, receiver, json);
        }
        throw new ApiException("either provide the configuration as query param or use endpoint /configurations/<config>/adapters/" + adapter + "/receivers/" + receiver, Response.Status.BAD_REQUEST);
    }

    @PUT
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/configurations/{configuration}/adapters/{adapter}/receivers/{receiver}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateReceiver(@PathParam(value="configuration") String configuration, @PathParam(value="adapter") String adapter, @PathParam(value="receiver") String receiver, Map<String, Object> json) {
        Object value = json.get("action");
        if (value instanceof String) {
            IbisAction action = null;
            if (value.equals("stop")) {
                action = IbisAction.STOPRECEIVER;
            } else if (value.equals("start")) {
                action = IbisAction.STARTRECEIVER;
            } else if (value.equals("incthread")) {
                action = IbisAction.INCTHREADS;
            } else if (value.equals("decthread")) {
                action = IbisAction.DECTHREADS;
            }
            if (action == null) {
                throw new ApiException("no or unknown action provided", Response.Status.BAD_REQUEST);
            }
            RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.IBISACTION);
            builder.addHeader("action", action.name());
            builder.addHeader("configuration", configuration);
            builder.addHeader("adapter", adapter);
            builder.addHeader("receiver", receiver);
            this.callAsyncGateway(builder);
            return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)"{\"status\":\"ok\"}").build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @GET
    @RolesAllowed(value={"IbisObserver", "IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/adapters/{adapter}/flow")
    @Produces(value={"text/plain"})
    @Deprecated
    public Response getAdapterFlowOld(@PathParam(value="adapter") String adapter, @QueryParam(value="configuration") String configuration) {
        if (StringUtils.isNotEmpty((CharSequence)configuration)) {
            return this.getAdapterFlow(configuration, adapter);
        }
        throw new ApiException("either provide the configuration as query param or use endpoint /configurations/<config>/adapters/" + adapter + "/flow", Response.Status.BAD_REQUEST);
    }

    @GET
    @RolesAllowed(value={"IbisObserver", "IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/configurations/{configuration}/adapters/{adapter}/flow")
    public Response getAdapterFlow(@PathParam(value="configuration") String configuration, @PathParam(value="adapter") String adapter) throws ApiException {
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.FLOW);
        builder.addHeader("configuration", configuration);
        builder.addHeader("adapter", adapter);
        return this.callSyncGateway(builder);
    }
}

