/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.management.web;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import nl.nn.adapterframework.management.bus.BusAction;
import nl.nn.adapterframework.management.bus.BusTopic;
import nl.nn.adapterframework.management.web.ApiException;
import nl.nn.adapterframework.management.web.FrankApiBase;
import nl.nn.adapterframework.management.web.RequestMessageBuilder;
import nl.nn.adapterframework.util.RequestUtils;
import nl.nn.adapterframework.util.StreamUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.springframework.messaging.Message;

@Path(value="/")
public class ShowLiquibaseScript
extends FrankApiBase {
    @GET
    @RolesAllowed(value={"IbisObserver", "IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/jdbc/liquibase")
    @Produces(value={"application/octet-stream"})
    public Response downloadScript(@QueryParam(value="configuration") String configuration) {
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.JDBC_MIGRATION, BusAction.DOWNLOAD);
        builder.addHeader("configuration", configuration);
        return this.callSyncGateway(builder);
    }

    @POST
    @RolesAllowed(value={"IbisObserver", "IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/jdbc/liquibase")
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    public Response generateSQL(MultipartBody inputDataMap) throws ApiException {
        String configuration = RequestUtils.resolveStringFromMap(inputDataMap, "configuration", null);
        Attachment filePart = inputDataMap.getAttachment("file");
        if (configuration == null || filePart == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.JDBC_MIGRATION, BusAction.UPLOAD);
        builder.addHeader("configuration", configuration);
        String filename = filePart.getContentDisposition().getParameter("filename");
        InputStream file = (InputStream)filePart.getObject(InputStream.class);
        try {
            String payload = StreamUtil.streamToString((InputStream)file);
            builder.setPayload(payload);
        }
        catch (IOException e) {
            throw new ApiException("unable to read payload", e);
        }
        if (StringUtils.endsWithIgnoreCase((CharSequence)filename, (CharSequence)".zip")) {
            throw new ApiException("uploading zip files is not supported!");
        }
        builder.addHeader("filename", filename);
        Message<?> response = this.sendSyncMessage(builder);
        String result = (String)response.getPayload();
        if (StringUtils.isEmpty((CharSequence)result)) {
            throw new ApiException("Make sure liquibase xml script exists for configuration [" + configuration + "]");
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("result", result);
        return Response.status((Response.Status)Response.Status.CREATED).entity(resultMap).build();
    }
}

