/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.management.web;

import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import nl.nn.adapterframework.management.bus.BusAction;
import nl.nn.adapterframework.management.bus.BusTopic;
import nl.nn.adapterframework.management.web.FrankApiBase;
import nl.nn.adapterframework.management.web.RequestMessageBuilder;

@Path(value="/configurations/{configuration}/monitors")
public class ShowMonitors
extends FrankApiBase {
    private static final String MONITOR_HEADER = "monitor";
    private static final String TRIGGER_HEADER = "trigger";

    @GET
    @Path(value="/")
    @RolesAllowed(value={"IbisObserver", "IbisDataAdmin", "IbisAdmin", "IbisTester"})
    public Response getMonitors(@PathParam(value="configuration") String configurationName, @DefaultValue(value="false") @QueryParam(value="xml") boolean showConfigXml) {
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.MONITORING, BusAction.GET);
        builder.addHeader("configuration", configurationName);
        builder.addHeader("xml", showConfigXml);
        return this.callSyncGateway(builder);
    }

    @POST
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response addMonitor(@PathParam(value="configuration") String configurationName, Map<String, Object> json) {
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.MONITORING, BusAction.UPLOAD);
        builder.addHeader("configuration", configurationName);
        String monitor = String.valueOf(json.remove(MONITOR_HEADER));
        json.put("name", monitor);
        builder.setJsonPayload(json);
        return this.callSyncGateway(builder);
    }

    @GET
    @RolesAllowed(value={"IbisObserver", "IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/{monitorName}")
    public Response getMonitor(@PathParam(value="configuration") String configurationName, @PathParam(value="monitorName") String monitorName, @DefaultValue(value="false") @QueryParam(value="xml") boolean showConfigXml) {
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.MONITORING, BusAction.GET);
        builder.addHeader("configuration", configurationName);
        builder.addHeader(MONITOR_HEADER, monitorName);
        builder.addHeader("xml", showConfigXml);
        return this.callSyncGateway(builder, true);
    }

    @PUT
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/{monitorName}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateMonitor(@PathParam(value="configuration") String configName, @PathParam(value="monitorName") String monitorName, Map<String, Object> json) {
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.MONITORING, BusAction.MANAGE);
        builder.addHeader("configuration", configName);
        builder.addHeader(MONITOR_HEADER, monitorName);
        Object state = json.remove("action");
        if (state != null) {
            builder.addHeader("state", String.valueOf(state));
        }
        builder.setJsonPayload(json);
        return this.callSyncGateway(builder);
    }

    @DELETE
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/{monitorName}")
    @Produces(value={"application/json"})
    public Response deleteMonitor(@PathParam(value="configuration") String configurationName, @PathParam(value="monitorName") String monitorName) {
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.MONITORING, BusAction.DELETE);
        builder.addHeader("configuration", configurationName);
        builder.addHeader(MONITOR_HEADER, monitorName);
        return this.callSyncGateway(builder);
    }

    @GET
    @RolesAllowed(value={"IbisObserver", "IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/{monitorName}/triggers")
    @Produces(value={"application/json"})
    public Response getTriggers(@PathParam(value="configuration") String configurationName, @PathParam(value="monitorName") String monitorName) {
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.MONITORING, BusAction.GET);
        builder.addHeader("configuration", configurationName);
        builder.addHeader(MONITOR_HEADER, monitorName);
        return this.callSyncGateway(builder, true);
    }

    @POST
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/{monitorName}/triggers")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createTrigger(@PathParam(value="configuration") String configName, @PathParam(value="monitorName") String monitorName, Map<String, Object> json) {
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.MONITORING, BusAction.UPLOAD);
        builder.addHeader("configuration", configName);
        builder.addHeader(MONITOR_HEADER, monitorName);
        builder.setJsonPayload(json);
        return this.callSyncGateway(builder);
    }

    @GET
    @RolesAllowed(value={"IbisObserver", "IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/{monitorName}/triggers/{trigger}")
    @Produces(value={"application/json"})
    public Response getTrigger(@PathParam(value="configuration") String configurationName, @PathParam(value="monitorName") String monitorName, @PathParam(value="trigger") Integer id) {
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.MONITORING, BusAction.GET);
        builder.addHeader("configuration", configurationName);
        builder.addHeader(MONITOR_HEADER, monitorName);
        builder.addHeader(TRIGGER_HEADER, id);
        return this.callSyncGateway(builder, true);
    }

    @PUT
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/{monitorName}/triggers/{trigger}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateTrigger(@PathParam(value="configuration") String configName, @PathParam(value="monitorName") String monitorName, @PathParam(value="trigger") int index, Map<String, Object> json) {
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.MONITORING, BusAction.MANAGE);
        builder.addHeader("configuration", configName);
        builder.addHeader(MONITOR_HEADER, monitorName);
        builder.addHeader(TRIGGER_HEADER, index);
        builder.setJsonPayload(json);
        return this.callSyncGateway(builder);
    }

    @DELETE
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/{monitorName}/triggers/{trigger}")
    @Produces(value={"application/json"})
    public Response deleteTrigger(@PathParam(value="configuration") String configurationName, @PathParam(value="monitorName") String monitorName, @PathParam(value="trigger") int id) {
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.MONITORING, BusAction.DELETE);
        builder.addHeader("configuration", configurationName);
        builder.addHeader(MONITOR_HEADER, monitorName);
        builder.addHeader(TRIGGER_HEADER, id);
        return this.callSyncGateway(builder);
    }
}

