/*
 * Decompiled with CFR 0.152.
 */
package nl.nn.adapterframework.management.web;

import java.util.Map;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import nl.nn.adapterframework.management.bus.BusAction;
import nl.nn.adapterframework.management.bus.BusTopic;
import nl.nn.adapterframework.management.web.FrankApiBase;
import nl.nn.adapterframework.management.web.Relation;
import nl.nn.adapterframework.management.web.RequestMessageBuilder;
import nl.nn.adapterframework.util.RequestUtils;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;

@Path(value="/")
public class ShowScheduler
extends FrankApiBase {
    @GET
    @RolesAllowed(value={"IbisObserver", "IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/schedules")
    @Relation(value="schedules")
    @Produces(value={"application/json"})
    public Response getSchedules() {
        return this.callSyncGateway(RequestMessageBuilder.create(this, BusTopic.SCHEDULER, BusAction.GET));
    }

    @GET
    @RolesAllowed(value={"IbisObserver", "IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/schedules/{groupName}/jobs/{jobName}")
    @Relation(value="schedules")
    @Produces(value={"application/json"})
    public Response getSchedule(@PathParam(value="jobName") String jobName, @PathParam(value="groupName") String groupName) {
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.SCHEDULER, BusAction.FIND);
        builder.addHeader("job", jobName);
        builder.addHeader("group", groupName);
        return this.callSyncGateway(builder);
    }

    @PUT
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/schedules")
    @Relation(value="schedules")
    @Produces(value={"application/json"})
    public Response updateScheduler(Map<String, Object> json) {
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.SCHEDULER, BusAction.MANAGE);
        builder.addHeader("operation", RequestUtils.getValue(json, "action"));
        return this.callSyncGateway(builder);
    }

    @PUT
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/schedules/{groupName}/jobs/{jobName}")
    @Relation(value="schedules")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response trigger(@PathParam(value="jobName") String jobName, @PathParam(value="groupName") String groupName, Map<String, Object> json) {
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.SCHEDULER, BusAction.MANAGE);
        builder.addHeader("operation", RequestUtils.getValue(json, "action"));
        builder.addHeader("job", jobName);
        builder.addHeader("group", groupName);
        return this.callSyncGateway(builder);
    }

    @POST
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/schedules")
    @Relation(value="schedules")
    @Produces(value={"application/json"})
    public Response createSchedule(MultipartBody input) {
        String jobGroupName = RequestUtils.resolveStringFromMap(input, "group");
        return this.createSchedule(jobGroupName, input);
    }

    @PUT
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/schedules/{groupName}/jobs/{jobName}")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public Response updateSchedule(@PathParam(value="groupName") String groupName, @PathParam(value="jobName") String jobName, MultipartBody input) {
        return ShowScheduler.createSchedule(this, groupName, jobName, input, true);
    }

    @POST
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/schedules/{groupName}/jobs")
    @Relation(value="schedules")
    @Produces(value={"application/json"})
    public Response createScheduleInJobGroup(@PathParam(value="groupName") String groupName, MultipartBody input) {
        return this.createSchedule(groupName, input);
    }

    private Response createSchedule(String groupName, MultipartBody input) {
        String jobName = RequestUtils.resolveStringFromMap(input, "name");
        return ShowScheduler.createSchedule(this, groupName, jobName, input, false);
    }

    protected static Response createSchedule(FrankApiBase base, String groupName, String jobName, MultipartBody inputDataMap, boolean overwrite) {
        RequestMessageBuilder builder = RequestMessageBuilder.create(base, BusTopic.SCHEDULER, BusAction.UPLOAD);
        builder.addHeader("job", jobName);
        builder.addHeader("group", groupName);
        builder.addHeader("cron", RequestUtils.resolveTypeFromMap(inputDataMap, "cron", String.class, ""));
        builder.addHeader("interval", RequestUtils.resolveTypeFromMap(inputDataMap, "interval", Integer.class, -1));
        builder.addHeader("adapter", RequestUtils.resolveStringFromMap(inputDataMap, "adapter"));
        builder.addHeader("receiver", RequestUtils.resolveTypeFromMap(inputDataMap, "receiver", String.class, ""));
        builder.addHeader("configuration", RequestUtils.resolveTypeFromMap(inputDataMap, "configuration", String.class, ""));
        builder.addHeader("listener", RequestUtils.resolveTypeFromMap(inputDataMap, "listener", String.class, ""));
        builder.addHeader("persistent", RequestUtils.resolveTypeFromMap(inputDataMap, "persistent", Boolean.TYPE, false));
        builder.addHeader("locker", RequestUtils.resolveTypeFromMap(inputDataMap, "locker", Boolean.TYPE, false));
        builder.addHeader("lockkey", RequestUtils.resolveTypeFromMap(inputDataMap, "lockkey", String.class, "lock4[" + jobName + "]"));
        builder.addHeader("message", RequestUtils.resolveStringFromMap(inputDataMap, "message"));
        builder.addHeader("description", RequestUtils.resolveStringFromMap(inputDataMap, "description"));
        if (overwrite) {
            builder.addHeader("overwrite", overwrite);
        }
        return base.callSyncGateway(builder);
    }

    @DELETE
    @RolesAllowed(value={"IbisDataAdmin", "IbisAdmin", "IbisTester"})
    @Path(value="/schedules/{groupName}/jobs/{jobName}")
    @Relation(value="schedules")
    @Produces(value={"application/json"})
    public Response deleteSchedules(@PathParam(value="jobName") String jobName, @PathParam(value="groupName") String groupName) {
        RequestMessageBuilder builder = RequestMessageBuilder.create(this, BusTopic.SCHEDULER, BusAction.DELETE);
        builder.addHeader("job", jobName);
        builder.addHeader("group", groupName);
        return this.callSyncGateway(builder);
    }
}

